<?php
namespace HIVE\HiveExtWkhtmltopdf\Controller;

/***
 *
 * This file is part of the "hive_ext_wkhtmltopdf" Extension for TYPO3 CMS.
 *
 * For the full copyright and license information, please read the
 * LICENSE.txt file that was distributed with this source code.
 *
 *  (c) 2017
 *
 ***/

/**
 * PdfController
 */
class PdfController extends \TYPO3\CMS\Extbase\Mvc\Controller\ActionController
{
    /**
     * pdfRepository
     *
     * @var \HIVE\HiveExtWkhtmltopdf\Domain\Repository\PdfRepository
     * @TYPO3\\CMS\\Extbase\\Annotation\\Inject
     */
    protected $pdfRepository = null;

    /**
     * pdfService
     *
     * @var \HIVE\HiveExtWkhtmltopdf\Service\WkhtmltopdfService
     * @TYPO3\\CMS\\Extbase\\Annotation\\Inject
     */
    protected $pdfService = NULL;

    /**
     * action renderPdf
     *
     * @param string $url
     * @param string $name
     * @return void
     */
    public function renderPdfAction($url, $name = NULL)
    {
        //var_dump("hallo");die;

        $scriptParams = $this->buildScriptOptions();
        $customScriptPath = $this->settings['customScriptPath'];
        $customFilePath = $this->settings['customFilePath'];
        $customWkhtmlToPdf = $this->settings['customWkhtmlToPdf'];

        $aPdfConfiguration = [
            'sheet_link' => $url,
            'sheet_filename' => str_replace(array("/","."," ","ä","ö","ü","Ø",",","'"),array("-","-","_","ae","oe","ue","","",""), $GLOBALS['TSFE']->page['title']).'.pdf',
            'sheet_params' => $scriptParams
        ];


        if($customScriptPath) {
            $aPdfConfiguration['sheet_scriptPath'] = $this->sanitizePath($customScriptPath);
        }

        if($customFilePath) {
            $aPdfConfiguration['sheet_filePath'] = $this->sanitizePath($customFilePath);
        }

        if($customWkhtmlToPdf) {
            $aPdfConfiguration['wkhtmlToPdf_path'] = $customWkhtmlToPdf;
        }

        if ($name) {
            $aPdfConfiguration['sheet_filename'] = str_replace(array("/","."," ","ä","ö","ü","Ø",",","'"),array("-","-","_","ae","oe","ue","","",""), $name).'.pdf';
        } else if($GLOBALS['TSFE']->tmpl->setup['plugin.']["metaseo."]["pageTitle."]["sitetitle"]) {
            $aPdfConfiguration['sheet_filename'] = str_replace(array("/","."," ","ä","ö","ü","Ø",",","'"),array("-","-","_","ae","oe","ue","","",""), $GLOBALS['TSFE']->tmpl->setup['plugin.']["metaseo."]["pageTitle."]["sitetitle"]).'.pdf';
        }

        $this->pdfService->generatePdf($aPdfConfiguration);
        exit(0);

    }

    protected function readScriptSettings() {
        $defaultSettings = array(
            //'footer-right' => '[page]/[toPage]',
            'footer-font-size' => '6',
            'header-font-size' => '6',
            'margin-left' => '15mm',
            'margin-right' => '15mm',
            'margin-top' => '25mm',
            'margin-bottom' => '25mm',
            'disable-internal-links' => '',
            'disable-external-links' => '',
          //'run-script' => "var imgEl = document.getElementsByTagName('img');for (var i=0; i<=imgEl.length; i++) {if(imgEl[i].getAttribute('data-echo')) {imgEl[i].setAttribute('src',imgEl[i].getAttribute('data-echo'));}}"
            'run-script' => "var imgEl = document.getElementsByTagName('img');var xhr = [];for (var i=0; i<imgEl.length; i++) {if(imgEl[i].getAttribute('data-echo')) { (function (i) { xhr[i] = new XMLHttpRequest();url = imgEl[i].getAttribute('data-echo');xhr[i].open('GET', url, true);xhr[i].onreadystatechange = function () {if (xhr[i].readyState == 4) {if (xhr[i].status == 200) {imgEl[i].src=imgEl[i].getAttribute('data-echo');} }};xhr[i].send();})(i);}};",
        );

        $tsSettings = $this->settings['scriptParams'];
        foreach($defaultSettings as $param => $value) {
            if(!isset($tsSettings[$param])) {
                $tsSettings[$param] = $value;
            }
        }

        $finalSettings = array();
        foreach($tsSettings as $param => $value) {
            $value = trim($value);
            if(substr($param, 0, 2) !== '--') {
                $param = '--' . $param;
            }
            $finalSettings[$param] = $value;
        }
        return $finalSettings;
    }

    /**
     * Creates the parameters for the wkhtmltopdf call.
     *
     * @return string The parameter string
     */
    protected function buildScriptOptions() {
        $aOptions = $this->settings['options'];
        $options = array();
        if($aOptions['pageURLInHeader']) {
            $options['--header-center'] = '[webpage]';
        }

        if($aOptions['copyrightNotice']) {
            $options['--footer-left'] = '© ' . date('Y', time()) . $this->conf['copyrightNotice'] . '';
        }

        if($aOptions['additionalStylesheet']) {
            $aOptions['additionalStylesheet'] = $this->sanitizePath($aOptions['additionalStylesheet'], FALSE);
            $options['--user-style-sheet'] = \TYPO3\CMS\Core\Utility\GeneralUtility::getIndpEnv('TYPO3_DOCUMENT_ROOT') . $aOptions['additionalStylesheet'];

        }

        $userSettings = $this->readScriptSettings();
        $options = array_merge($options, $userSettings);

        $paramsString = '';
        foreach($options as $param => $value) {
            if(strlen($value) > 0) {
                $value = '"' . $value . '"';
            }
            $paramsString .= ' ' . $param . ' ' . $value;
        }
        return $paramsString;
    }

    /**
     * Makes sure that given path has a slash as first and last character
     *
     * @param	string		$path: The path to be sanitized
     * @return	Sanitized path
     */
    protected function sanitizePath($path, $trailingSlash = TRUE) {

        // slash as last character
        if($trailingSlash && substr($path, (strlen($path) - 1)) !== '/') {
            $path .= '/';
        }

        //slash as first character
        if(substr($path, 0, 1) !== '/') {
            $path = '/' . $path;
        }

        return $path;
    }
}
