<?php
namespace HIVE\HiveExtWkhtmltopdf\Service;


class WkhtmltopdfService implements \TYPO3\CMS\Core\SingletonInterface {

    /**
     * $sFilePathDefault
     *
     * @var \string
     */
    public $sFilePathDefault = '/typo3temp/hive_ext_wkhtmltopdf/';


    /**
     * generates a pdf from an existing html website
     *
     * @param array $aPdfConfiguration
     * @param string $sFilePathServer
     * @param string $sFilePathWeb
     */
    public function generatePdf (array $aPdfConfiguration, $sFilePathServer = "", $sFilePathWeb = "") {

        if($aPdfConfiguration['sheet_filePath']) {
            $this->sFilePathDefault = $aPdfConfiguration['sheet_filePath'];
        }

        // set valid paths
        $sFilePathServer = \TYPO3\CMS\Core\Utility\GeneralUtility::getIndpEnv( 'TYPO3_DOCUMENT_ROOT' ) . ($sFilePathServer != "" ? $sFilePathServer : $this->sFilePathDefault);
        $sFilePathWeb = $this->siteURL() . ($sFilePathWeb != "" ? $sFilePathWeb : $this->sFilePathDefault);

        if(!is_dir($sFilePathServer)) {
            mkdir($sFilePathServer,0777);
        }

        if ($aPdfConfiguration['wkhtmlToPdf_path']) {
            $wkhtmltopdfPaht = $aPdfConfiguration['wkhtmlToPdf_path'];
        } else {
            $wkhtmltopdfPaht = 'wkhtmltopdf';
        }

        // clean filename from non-valid characters
        $sFilename = preg_replace('/[^a-zA-Z0-9-_\.]/','', $aPdfConfiguration["sheet_filename"]);

//        https://wkhtmltopdf.org/usage/wkhtmltopdf.txt
//        -B, --margin-bottom <unitreal>        Set the page bottom margin
//        -L, --margin-left <unitreal>          Set the page left margin (default 10mm)
//        -R, --margin-right <unitreal>         Set the page right margin (default 10mm)
//        -T, --margin-top <unitreal>           Set the page top margin
//        -O, --orientation <orientation>       Set orientation to Landscape or Portrait (default Portrait)
//        -s, --page-size <Size>                Set paper size to: A4, Letter, etc. (default A4)
//        --title <text>                        The title of the generated pdf file (The title of the first document is used if not specified)
//        --allow <path>                        Allow the file or files from the specified folder to be loaded (repeatable)
//        --background                          Do print background (default)
//        --no-background                       Do not print background
//        --cache-dir <path>                    Web cache directory
//        --custom-header <name> <value>        Set an additional HTTP header (repeatable)
//        --custom-header-propagation           Add HTTP headers specified by
//        --custom-header                       for each resource request.
//        --no-custom-header-propagation        Do not add HTTP headers specified by
//        --custom-header                       for each resource request.
//        --encoding <encoding>
//        --images                              Do load or print images (default)
//        --no-images                           Do not load or print images
//        --disable-internal-links              Do not make local links
//        --enable-internal-links               Make local links (default)
//        --stop-slow-scripts                   Stop slow running javascripts (default)
//        --zoom <float>                        Use this zoom factor (default 1)
//        --footer-center <text>                Centered footer text
//        --footer-font-name <name>             Set footer font name (default Arial)
//        --footer-font-size <size>             Set footer font size (default 12)
//        --footer-html <url>                   Adds a html footer
//        --footer-left <text>                  Left aligned footer text
//        --footer-line                         Display line above the footer
//        --no-footer-line                      Do not display line above the footer (default)
//        --footer-right <text>                 Right aligned footer text
//        --footer-spacing <real>               Spacing between footer and content in mm (default 0)
//        --header-center <text>                Centered header text
//        --header-font-name <name>             Set header font name (default Arial)
//        --header-font-size <size>             Set header font size (default 12)
//        --header-html <url>                   Adds a html header
//        --header-left <text>                  Left aligned header text
//        --header-line                         Display line below the header
//        --no-header-line                      Do not display line below the header (default)
//        --header-right <text>                 Right aligned header text
//        --header-spacing <real>               Spacing between header and content in mm (default 0)
//        --replace <name> <value>              Replace [name] with value in header and footer (repeatable)


//        FOOTERS & HEADERS
//        * [page]       Replaced by the number of the pages currently being printed
//        * [frompage]   Replaced by the number of the first page to be printed
//        * [topage]     Replaced by the number of the last page to be printed
//        * [webpage]    Replaced by the URL of the page being printed
//        * [section]    Replaced by the name of the current section
//        * [subsection] Replaced by the name of the current subsection
//        * [date]       Replaced by the current date in system local format
//        * [isodate]    Replaced by the current date in ISO 8601 extended format
//        * [time]       Replaced by the current time in system local format
//        * [title]      Replaced by the title of the of the current page object
//        * [doctitle]   Replaced by the title of the output document
//        * [sitepage]   Replaced by the number of the page in the current site being converted
//        * [sitepages]  Replaced by the number of pages in the current site being converted


        if ($_COOKIE["fe_typo_user"]) {
            $sShellExec = "cd ".$sFilePathServer." && ".$aPdfConfiguration['sheet_scriptPath'].$wkhtmltopdfPaht." --cookie fe_typo_user ".$_COOKIE["fe_typo_user"]." ".$aPdfConfiguration['sheet_params']." '".$aPdfConfiguration['sheet_link']."' ".$aPdfConfiguration['sheet_filename']."";

        } else {
            $sShellExec = "cd ".$sFilePathServer." && ".$aPdfConfiguration['sheet_scriptPath'].$wkhtmltopdfPaht." ".$aPdfConfiguration['sheet_params']." '".$aPdfConfiguration['sheet_link']."' ".$aPdfConfiguration['sheet_filename']."";

        }
        //var_dump($_COOKIE["fe_typo_user"]);
        //var_dump($sShellExec);die;
        shell_exec($sShellExec);

        // determine filesize
        $iFilesize = filesize($sFilePathServer . $sFilename);

        // if file exists set header information
        if (file_exists($sFilePathServer . $sFilename)) {

            header('Content-type: application/pdf');
            header('Content-Transfer-Encoding: Binary');
            header('Content-Length:' . $iFilesize);
            header('Content-Disposition: inline; filename="' . $sFilename . '"');
            header('X-Robots-Tag: noindex');
            header("Pragma: no-cache");
            header("Expires: 0");

            ob_clean();
            flush();

            // unlink file if readable
            if (readfile($sFilePathWeb . $sFilename)) {
                unlink($sFilePathServer . $sFilename);
            }
            exit(0);

        } else {

            exit(0);

        }

    }

    /**
     * set the current protocol + domain for relevant file path (web)
     *
     * @return string
     */
    function siteURL() {

        // set current protocol | https or http
        $sProtocol = (!empty($_SERVER['HTTPS']) && $_SERVER['HTTPS'] !== 'off' || $_SERVER['SERVER_PORT'] == 443) ? "https://" : "http://";

        // set current domain name
        $sDomainName = $_SERVER['HTTP_HOST'];

        return $sProtocol.$sDomainName;

    }

}