<?php
declare(strict_types=1);

namespace TEUFELS\Htc19ExtNonconformityreport\Command;

use Symfony\Component\Console\Command\Command;
use Symfony\Component\Console\Input\InputInterface;
use Symfony\Component\Console\Input\InputOption;
use Symfony\Component\Console\Output\OutputInterface;
use Symfony\Component\Console\Style\SymfonyStyle;
use TYPO3\CMS\Core\Utility\GeneralUtility;
use TYPO3\CMS\Core\Database\ConnectionPool;

/**
 * This task checks if the user has registered 10 Years (3650 days) ago
 */
class CheckFrontendUserExpirationCommand extends Command
{
    /**
     * Configures the current command.
     */
    protected function configure()
    {
        parent::configure();
        $this->setDescription('Check for users last logged in over ten years ago.')
            ->addOption('recipient', null, InputOption::VALUE_REQUIRED, 'recipient', 'Service@hettichlab.com');
    }

    /**
     * Executes the current command.
     *
     * This method is not abstract because you can use this class
     * as a concrete class. In this case, instead of defining the
     * execute() method, you set the code to execute by passing
     * a Closure to the setCode() method.
     *
     * @param InputInterface $input
     * @param OutputInterface $output
     *
     * @return int|null null or 0 if everything went fine, or an error code
     *
     * @throws \TYPO3\CMS\Core\Cache\Exception\NoSuchCacheException
     *
     * @see setCode()
     */
    protected function execute(InputInterface $input, OutputInterface $output)
    {
        $io = new SymfonyStyle($input, $output);

        $recipient = $input->getOption('recipient');
        $io->success($recipient);

        $registeredSinceDays = 3650;

        $queryBuilder = GeneralUtility::makeInstance(ConnectionPool::class)->getQueryBuilderForTable('fe_users');
        $result = $queryBuilder
            ->select('uid','username','name','address','telephone','email','crdate','lastlogin','lastlogin')
            ->from('fe_users')
            ->where( $queryBuilder->expr()->lte('fe_users.lastlogin', $queryBuilder->createNamedParameter((time() - $registeredSinceDays*24*60*60), \PDO::PARAM_INT)) )
            ->execute()
            ->fetchAll();

        if(empty($result)){
            $mailBody = 'EXPIRING USERS FROM HETTICH SERVICE PORTAL' . LF . '- - - - - - - - - - - - - - - - - - - - -' . LF . 'No users last time logged in before: ' . date("d.m.Y", (time() - $registeredSinceDays*24*60*60));
        } else {
            $mailBody = 'EXPIRING USERS FROM HETTICH SERVICE PORTAL' . LF . '- - - - - - - - - - - - - - - - - - - - -' . LF . 'List users last time logged in before: ' . date("d.m.Y", (time() - $registeredSinceDays*24*60*60)) . LF;
            foreach ($result as $key => $values) {

                $mailBody = $mailBody . LF . 'user: [';

                foreach ($values as $key => $value) {

                    if($key == 'crdate'){
                        $mailBody = $mailBody . 'registration Date: ' .  date("d.m.Y", $value) . ', ';
                    } elseif ($key == 'lastlogin') {
                        if($value > 0){
                            $mailBody = $mailBody . 'last Login: ' .  date("d.m.Y", $value);
                        } else {
                            $mailBody = $mailBody . 'last Login: ' . 'never';
                        }

                    } else {
                        $mailBody = $mailBody . $key . ': ' . $value . ', ';
                    }

                }

                $mailBody = $mailBody . ']';
            }

            // Prepare mailer and send the mail
            try {
                // Create the message
                $mail = \TYPO3\CMS\Core\Utility\GeneralUtility::makeInstance(\TYPO3\CMS\Core\Mail\MailMessage::class);

                // Prepare and send the message
                $mail

                    // Defining the "From" email address and name as an object
                    // (email clients will display the name)
                    ->from(new \Symfony\Component\Mime\Address('info@hettichlab.com', 'HETTICH SERVICE PORTAL EXPIRING USERS'))

                    // Set the "To" addresses
                    ->to(
                        new \Symfony\Component\Mime\Address($recipient, 'Andreas Hettich GmbH & Co. KG')
                    )

                    // Give the message a subject
                    ->subject('HETTICH SERVICE PORTAL EXPIRING USERS')

                    // Give it the text message
                    ->text($mailBody)

                    // And finally send it
                    ->send()
                ;

                $io->success('Mail sent');

            } catch (\Exception $e) {
                throw new \TYPO3\CMS\Core\Exception($e->getMessage(), 1476048416);
            }

        }

        $io->success('Done');

        return 0;
    }
}
