<?php
namespace TEUFELS\Htc19ExtNonconformityreport\Controller;

use TEUFELS\Htc19ExtNonconformityreport\Property\TypeConverter\UploadedFileReferenceConverter;
use TYPO3\CMS\Core\Utility\GeneralUtility;
use TYPO3\CMS\Extbase\Configuration\ConfigurationManagerInterface;
use TYPO3\CMS\Extbase\Mvc\Web\Routing\UriBuilder;
use GuzzleHttp\Client;
/***
 *
 * This file is part of the "htc19_ext_nonconformityreport" Extension for TYPO3 CMS.
 *
 * For the full copyright and license information, please read the
 * LICENSE.txt file that was distributed with this source code.
 *
 *  (c) 2019 Bastian Holzem <b.holzem@teufels.com>, teufels GmbH
 *
 ***/

/**
 * ReportController
 */
class ReportController extends \TYPO3\CMS\Extbase\Mvc\Controller\ActionController
{
    /**
     * reportRepository
     *
     * @var \TEUFELS\Htc19ExtNonconformityreport\Domain\Repository\ReportRepository
     * @TYPO3\CMS\Extbase\Annotation\Inject
     */
    protected $reportRepository = null;

    /**
     * logistikRepository
     *
     * @var \TEUFELS\Htc19ExtNonconformityreport\Domain\Repository\LogistikRepository
     * @TYPO3\CMS\Extbase\Annotation\Inject
     */
    protected $logistikRepository = null;

    /**
     * kundenserviceRepository
     *
     * @var \TEUFELS\Htc19ExtNonconformityreport\Domain\Repository\KundenserviceRepository
     * @TYPO3\CMS\Extbase\Annotation\Inject
     */
    protected $kundenserviceRepository = null;

    /**
     * massnahmenRepository
     *
     * @var \TEUFELS\Htc19ExtNonconformityreport\Domain\Repository\MassnahmenRepository
     * @TYPO3\CMS\Extbase\Annotation\Inject
     */
    protected $massnahmenRepository = null;

    /**
     * fehlerortRepository
     *
     * @var \TEUFELS\Htc19ExtNonconformityreport\Domain\Repository\FehlerortRepository
     * @TYPO3\CMS\Extbase\Annotation\Inject
     */
    protected $fehlerortRepository = null;

    /**
     * personenschadenRepository
     *
     * @var \TEUFELS\Htc19ExtNonconformityreport\Domain\Repository\PersonenschadenRepository
     * @TYPO3\CMS\Extbase\Annotation\Inject
     */
    protected $personenschadenRepository = null;

    /**
     * crashRepository
     *
     * @var \TEUFELS\Htc19ExtNonconformityreport\Domain\Repository\CrashRepository
     * @TYPO3\CMS\Extbase\Annotation\Inject
     */
    protected $crashRepository = null;

    /**
     * kurzschlussRepository
     *
     * @var \TEUFELS\Htc19ExtNonconformityreport\Domain\Repository\KurzschlussRepository
     * @TYPO3\CMS\Extbase\Annotation\Inject
     */
    protected $kurzschlussRepository = null;

    /**
     * produktkategorieRepository
     *
     * @var \TEUFELS\Htc19ExtNonconformityreport\Domain\Repository\ProduktkategorieRepository
     * @TYPO3\CMS\Extbase\Annotation\Inject
     */
    protected $produktkategorieRepository = null;

    /**
     * produktgruppeRepository
     *
     * @var \TEUFELS\Htc19ExtNonconformityreport\Domain\Repository\ProduktgruppeRepository
     * @TYPO3\CMS\Extbase\Annotation\Inject
     */
    protected $produktgruppeRepository = null;

    /**
     * produktRepository
     *
     * @var \TEUFELS\Htc19ExtNonconformityreport\Domain\Repository\ProduktRepository
     * @TYPO3\CMS\Extbase\Annotation\Inject
     */
    protected $produktRepository = null;

    /**
     * action new
     *
     * @param string $sError
     *
     * @return void
     */
    public function newAction($sError = '')
    {
        // get starting referenznummer
        /*
        $objectManager = GeneralUtility::makeInstance('TYPO3\\CMS\\Extbase\\Object\\ObjectManager');
        $configurationManager = $objectManager->get('TYPO3\\CMS\\Extbase\\Configuration\\ConfigurationManager');
        $fullTyposcriptSettings = $configurationManager->getConfiguration(ConfigurationManagerInterface::CONFIGURATION_TYPE_FULL_TYPOSCRIPT);
        $starting_referenznummer = $fullTyposcriptSettings['plugin.']['tx_htc19extnonconformityreport.']['settings.']['referenznummer_start'];
        */
        $current_date = date('d.m.Y', time());

        /*
        $oLastRecord = $this->reportRepository->findLastReport();
        if ($oLastRecord === NULL) {
            $new_referenznummer = $starting_referenznummer;
        } else {
            $new_referenznummer = $oLastRecord->getReferenznummer() + 1;
        }*/

        //set referencenumber only at create
        $new_referenznummer = 0;

        $oLogistik = $this->logistikRepository->findAll();
        $oKundenservice = $this->kundenserviceRepository->findAll();
        $oMassnahmen = $this->massnahmenRepository->findAll();
        $oFehlerort = $this->fehlerortRepository->findAll();
        $oPersonenschaden = $this->personenschadenRepository->findAll();
        $oCrash = $this->crashRepository->findAll();
        $oKurzschluss = $this->kurzschlussRepository->findAll();
        $oProduktkategorie = $this->produktkategorieRepository->findAll();
        //get Productcategory without "Zubehoer"
        $oProduktkategorie = $this->produktkategorieRepository->findByAllExcludeUid(2);
        $oProduktgruppe = $this->produktgruppeRepository->findAll();
        $oProduktgruppeZubehoer = $this->produktgruppeRepository->findByCategoryUid(2);
        $oProdukt = $this->produktRepository->findAll();
        // get loggedin user
        $user = null;
        if (isset($GLOBALS['TSFE']->fe_user) and $GLOBALS['TSFE']->fe_user instanceof \TYPO3\CMS\Frontend\Authentication\FrontendUserAuthentication) {
            $user = $GLOBALS['TSFE']->fe_user->user;
        }
        $this->view->assign('sError', $sError);
        $this->view->assign('user', $user);
        $this->view->assign('current_date', $current_date);
        $this->view->assign('new_referenznummer', $new_referenznummer);
        $this->view->assign('oLogistik', $oLogistik);
        $this->view->assign('oKundenservice', $oKundenservice);
        $this->view->assign('oMassnahmen', $oMassnahmen);
        $this->view->assign('oFehlerort', $oFehlerort);
        $this->view->assign('oPersonenschaden', $oPersonenschaden);
        $this->view->assign('oCrash', $oCrash);
        $this->view->assign('oKurzschluss', $oKurzschluss);
        $this->view->assign('oProduktkategorie', $oProduktkategorie);
        $this->view->assign('oProduktgruppe', $oProduktgruppe);
        $this->view->assign('oProduktgruppeZubehoer', $oProduktgruppeZubehoer);
        $this->view->assign('oProdukt', $oProdukt);

        $oRequest = $this->request;
        $oOriginalRequest = $oRequest->getOriginalRequest();
        if (null === $oOriginalRequest) {
            $this->view->assign('aRequestArguments', []);
        } else {
            $aRequestArguments = $oOriginalRequest->getArguments();
            $this->view->assign('aRequestArguments', $aRequestArguments);
        }


    }

    /**
     * action create
     *
     * @param \TEUFELS\Htc19ExtNonconformityreport\Domain\Model\Report $newReport
     * @return void
     */
    public function createAction(\TEUFELS\Htc19ExtNonconformityreport\Domain\Model\Report $newReport)
    {
        // force to store data
        $this->reportRepository->add($newReport);
        $this->persistenceManager = \TYPO3\CMS\Core\Utility\GeneralUtility::makeInstance('TYPO3\\CMS\\Extbase\\Persistence\\Generic\\PersistenceManager');
        $this->persistenceManager->persistAll();

        // get starting referenznummer
        $objectManager = GeneralUtility::makeInstance('TYPO3\\CMS\\Extbase\\Object\\ObjectManager');
        $configurationManager = $objectManager->get('TYPO3\\CMS\\Extbase\\Configuration\\ConfigurationManager');
        $fullTyposcriptSettings = $configurationManager->getConfiguration(ConfigurationManagerInterface::CONFIGURATION_TYPE_FULL_TYPOSCRIPT);
        $starting_referenznummer = $fullTyposcriptSettings['plugin.']['tx_htc19extnonconformityreport.']['settings.']['referenznummer_start'];

        //set Referenznumber
        $newReport->setReferenznummer( $starting_referenznummer + $newReport->getUid() );

        $this->addFlashMessage('Your Report with Referenznumber ' . $newReport->getReferenznummer() . ' was submitted.');
        //$this->addFlashMessage('The object was created. Please be aware that this action is publicly accessible unless you implement an access check. See https://docs.typo3.org/typo3cms/extensions/extension_builder/User/Index.html', '', \TYPO3\CMS\Core\Messaging\AbstractMessage::WARNING);
        $requestArgs = $this->request->getArguments();
        if ($requestArgs['upload']) {
            foreach ($requestArgs['upload'] as $file) {
                if ($file['name']) {
                    $this->setUpload($newReport->getReferenznummer(), $file, $newReport, null, 'upload');
                }
            }
            $this->zipUpload($newReport->getReferenznummer(), 'upload.zip');
        }

        # Update auf das Repository anwenden und speichern
        $this->reportRepository->update($newReport);
        $this->persistenceManager->persistAll();

        $this->exportXML($newReport);

        //Redirect to Page with show Plugin
        $this->redirect('show', 'Report', null, ['report' => $newReport]);
    }

    /**
     * action show
     *
     * @param \TEUFELS\Htc19ExtNonconformityreport\Domain\Model\Report $report
     */
    public function showAction(\TEUFELS\Htc19ExtNonconformityreport\Domain\Model\Report $report)
    {
        $this->view->assign('report', $report);
    }

    /**
     * initialize create action
     *
     * @param void
     */
    public function initializeCreateAction()
    {

        /*
         * Handle e.g. post_max_size errors: PHP does remove $_POST and $_FILES in this case.
         * Redirect to new action. Otherwise devil may eat you alive!!!
         */
        if (isset($_POST) and count($_POST) == 0) {
            $this->redirect('new', 'Report', null, ['sError' => 'server_error']);
        }

        if ($this->arguments->hasArgument('newReport')) {
            $this->arguments->getArgument('newReport')->getPropertyMappingConfiguration()->forProperty('reklamationsdatum')->setTypeConverterOption('TYPO3\\CMS\\Extbase\\Property\\TypeConverter\\DateTimeConverter', \TYPO3\CMS\Extbase\Property\TypeConverter\DateTimeConverter::CONFIGURATION_DATE_FORMAT, 'd.m.Y');
            $this->arguments->getArgument('newReport')->getPropertyMappingConfiguration()->allowProperties('fehlermeldungZeitpunkt');
            $this->arguments->getArgument('newReport')->getPropertyMappingConfiguration()->forProperty('fehlermeldungZeitpunkt')->setTypeConverterOption('TYPO3\\CMS\\Extbase\\Property\\TypeConverter\\DateTimeConverter', \TYPO3\CMS\Extbase\Property\TypeConverter\DateTimeConverter::CONFIGURATION_DATE_FORMAT, 'Y-m-d');
            $this->arguments->getArgument('newReport')->getPropertyMappingConfiguration()->allowProperties('logistik');
            $this->arguments->getArgument('newReport')->getPropertyMappingConfiguration()->setTargetTypeForSubProperty('logistik', 'array');
            $this->arguments->getArgument('newReport')->getPropertyMappingConfiguration()->setMapping('logistikSelection', 'logistik');
            $this->arguments->getArgument('newReport')->getPropertyMappingConfiguration()->allowProperties('kundenservice');
            $this->arguments->getArgument('newReport')->getPropertyMappingConfiguration()->setTargetTypeForSubProperty('kundenservice', 'array');
            $this->arguments->getArgument('newReport')->getPropertyMappingConfiguration()->setMapping('kundenserviceSelection', 'kundenservice');
            $this->arguments->getArgument('newReport')->getPropertyMappingConfiguration()->allowProperties('massnahmen');
            $this->arguments->getArgument('newReport')->getPropertyMappingConfiguration()->setTargetTypeForSubProperty('massnahmen', 'array');
            $this->arguments->getArgument('newReport')->getPropertyMappingConfiguration()->setMapping('massnahmenSelection', 'massnahmen');
            $this->arguments->getArgument('newReport')->getPropertyMappingConfiguration()->allowProperties('fehlerort');
            $this->arguments->getArgument('newReport')->getPropertyMappingConfiguration()->setTargetTypeForSubProperty('fehlerort', 'array');
            $this->arguments->getArgument('newReport')->getPropertyMappingConfiguration()->setMapping('fehlerortSelection', 'fehlerort');
            $this->arguments->getArgument('newReport')->getPropertyMappingConfiguration()->allowProperties('personenschaden');
            $this->arguments->getArgument('newReport')->getPropertyMappingConfiguration()->setTargetTypeForSubProperty('personenschaden', 'array');
            $this->arguments->getArgument('newReport')->getPropertyMappingConfiguration()->setMapping('personenschadenSelection', 'personenschaden');
            $this->arguments->getArgument('newReport')->getPropertyMappingConfiguration()->allowProperties('crash');
            $this->arguments->getArgument('newReport')->getPropertyMappingConfiguration()->setTargetTypeForSubProperty('crash', 'array');
            $this->arguments->getArgument('newReport')->getPropertyMappingConfiguration()->setMapping('crashSelection', 'crash');
            $this->arguments->getArgument('newReport')->getPropertyMappingConfiguration()->allowProperties('kurzschluss');
            $this->arguments->getArgument('newReport')->getPropertyMappingConfiguration()->setTargetTypeForSubProperty('kurzschluss', 'array');
            $this->arguments->getArgument('newReport')->getPropertyMappingConfiguration()->setMapping('kurzschlussSelection', 'kurzschluss');


            $request = $this->request;

            $aNewReport = $request->getArgument('newReport');

            /* @var \TYPO3\CMS\Extbase\Validation\ValidatorResolver $validatorResolver */
            $validatorResolver = $this->objectManager->get('TYPO3\\CMS\\Extbase\\Validation\\ValidatorResolver');

            /* @var \TYPO3\CMS\Extbase\Validation\Validator\ConjunctionValidator $modelValidator */
            $modelValidator = $validatorResolver->getBaseValidatorConjunction('TEUFELS\\Htc19ExtNonconformityreport\\Domain\\Model\\Report');

            /* @var \TYPO3\CMS\Extbase\Validation\Validator\ConjunctionValidator $productModelValidator */
            $productModelValidator = $validatorResolver->getBaseValidatorConjunction('TEUFELS\\Htc19ExtNonconformityreport\\Domain\\Model\\Product');

            $aMandatoryFields = [];
            $aOtherFields = [];

            $sAllowed = '[\\w\\s\\d\\-\\+\\.\\:\\,\\!\\?ßäöüÄÖÜ\\&\\(\\)\\/]';

            $aPatterns = [
                $sAllowed . '+', // mandatory fields
                $sAllowed . '*', // not mandatory fields
                '((((' . $sAllowed . '+):Ja)|((' . $sAllowed . '+):Nein));?)+', // mandatory radio buttons inside sections
                '((' . $sAllowed . '+);?)+', // mandatory checkboxes inside sections
                '((' . $sAllowed . '+);?)*', // not mandatory checkboxes inside sections
                'haendler|endkunde',
            ];

            $aDatePatterns = [
                '([0-9]{4}-[0-9]{2})?',
                '([0-9]{4}-[0-9]{2}-[0-9]{2})?',
            ];

            foreach ($modelValidator->getValidators() as $validator) {

                $validator->addPropertyValidator(
                    'erfasserSelect',
                    $this->objectManager->get('TYPO3\\CMS\\Extbase\\Validation\\Validator\\NotEmptyValidator')
                );

                $aMandatoryFields[] = ['erfasserSelect', $aPatterns[5]];

                if (isset($aNewReport["erfasserSelect"]) && $aNewReport["erfasserSelect"] === "haendler") {

                    $aMandatoryFields[] = ['kundeNummer', $aPatterns[0]];
                    $aMandatoryFields[] = ['kundeName', $aPatterns[0]];
                    $aMandatoryFields[] = ['kundeTelefon', $aPatterns[0]];
                    $aMandatoryFields[] = ['kundeEmail', 'EmailAddressValidator'];
                    $aMandatoryFields[] = ['kundeAdresse', $aPatterns[0]];

                    if (isset($aNewReport["endkundeAbweichend"]) && $aNewReport["endkundeAbweichend"] === "1") {

                        $aMandatoryFields[] = ['endkundeName', $aPatterns[0]];
                        $aMandatoryFields[] = ['endkundeTelefon', $aPatterns[0]];
                        $aMandatoryFields[] = ['endkundeEmail', 'EmailAddressValidator'];
                        $aMandatoryFields[] = ['endkundeAdresse', $aPatterns[0]];

                    }

                }

                if (isset($aNewReport["erfasserSelect"]) && $aNewReport["erfasserSelect"] === "endkunde") {

                    $aMandatoryFields[] = ['endkundeName', $aPatterns[0]];
                    $aMandatoryFields[] = ['endkundeTelefon', $aPatterns[0]];
                    $aMandatoryFields[] = ['endkundeEmail', 'EmailAddressValidator'];
                    $aMandatoryFields[] = ['endkundeAdresse', $aPatterns[0]];

                }

                $aMandatoryFields[] = ['reklamationTechnisch', 'BooleanValidator'];
//                    $aMandatoryFields[] = ['produktSelect', $aPatterns[5]];
//                    $aMandatoryFields[] = ['zubehoerSelect', $aPatterns[5]];
//                    $aMandatoryFields[] = ['ersatzteilSelect', $aPatterns[5]];
                $aMandatoryFields[] = ['fehlermeldungSelect', 'BooleanValidator'];
                $aMandatoryFields[] = ['programmSelect', 'BooleanValidator'];
                $aMandatoryFields[] = ['personenschadenSelect', 'BooleanValidator'];
                $aMandatoryFields[] = ['kurzschlussSelect', 'BooleanValidator'];
                $aMandatoryFields[] = ['crashSelect', 'BooleanValidator'];

                if (isset($aNewReport["reklamationTechnisch"]) && $aNewReport["reklamationTechnisch"] === "1") {

                    /*
                     * reklamationTechnisch requires minimum one subtopic
                     * if no subtopic is selected validate some mandatory fields from first subtopic to get an error message
                     * This workaround is neccessary because the subtopics are not part of the report domain model!
                     */

                    if (
                        (!$request->hasArgument("produktSelect") || ($request->hasArgument("produktSelect") && $request->getArgument("produktSelect") === "0"))
                        && (!$request->hasArgument("zubehoerSelect") || ($request->hasArgument("zubehoerSelect") && $request->getArgument("zubehoerSelect") === "0"))
                        && (!$request->hasArgument("ersatzteilSelect") || ($request->hasArgument("ersatzteilSelect") && $request->getArgument("ersatzteilSelect") === "0"))
                        && (isset($aNewReport["fehlermeldungSelect"]) && $aNewReport["fehlermeldungSelect"] === "0")
                        && (isset($aNewReport["programmSelect"]) && $aNewReport["programmSelect"] === "0")
                        && (isset($aNewReport["personenschadenSelect"]) && $aNewReport["personenschadenSelect"] === "0")
                        && (isset($aNewReport["kurzschlussSelect"]) && $aNewReport["kurzschlussSelect"] === "0")
                        && (isset($aNewReport["crashSelect"]) && $aNewReport["crashSelect"] === "0")
                    ) {
                        // Use custom validator for custom error message with custom title
                        $newValidator = $validatorResolver->createValidator(
                            "TEUFELS\\Htc19ExtNonconformityreport\\Validator\\TechnicalProblemRegularExpressionValidator",
                            ['regularExpression' => '/^{"geraetekategorie":"' . $aPatterns[0] . '","geraetebezeichnung":"' . $aPatterns[0] . '","artikelnummer":"' . $aPatterns[0] . '","serialnummer":"' . $aPatterns[0] . '","herstelldatum":"' . $aDatePatterns[0] . '"}$/u']
                        );

                        $validator->addPropertyValidator(
                            'produkt',
                            $newValidator
                        );
                    }


                    if ($request->hasArgument("produktSelect") && $request->getArgument("produktSelect") === "1") {

                        $newValidator = $validatorResolver->createValidator(
                            "TYPO3\\CMS\\Extbase\\Validation\\Validator\\RegularExpressionValidator",
                            ['regularExpression' => '/^{"geraetekategorie":"' . $aPatterns[0] . '","geraetebezeichnung":"' . $aPatterns[0] . '","artikelnummer":"' . $aPatterns[0] . '","serialnummer":"' . $aPatterns[0] . '","herstelldatum":"' . $aDatePatterns[0] . '"}$/u']
                        );

                        $validator->addPropertyValidator(
                            'produkt',
                            $newValidator
                        );

                        $newValidator = $validatorResolver->createValidator(
                            "TYPO3\\CMS\\Extbase\\Validation\\Validator\\RegularExpressionValidator",
                            ['regularExpression' => '/^{"geraetebezeichnung":"' . $aPatterns[1] . '","artikelnummer":"' . $aPatterns[1] . '","serialchargennummer":"' . $aPatterns[1] . '","kaufdatum":"' . $aDatePatterns[1] . '"}$/u']
                        );

                        $validator->addPropertyValidator(
                            'defektekomponente',
                            $newValidator
                        );

                    }

                    if ($request->hasArgument("zubehoerSelect") && $request->getArgument("zubehoerSelect") === "1") {

                        if ($request->hasArgument("zubehoer") && is_array($request->getArgument("zubehoer"))) {

                            if (array_key_exists('serialnummer', $request->getArgument("zubehoer"))
                                && array_key_exists('chargennummer', $request->getArgument("zubehoer"))) {

                                $newValidator = $validatorResolver->createValidator(
                                    "TYPO3\\CMS\\Extbase\\Validation\\Validator\\RegularExpressionValidator",
                                    ['regularExpression' => '/^{"zubehoerkategorie":"' . $aPatterns[0] . '","artikelnummer":"' . $aPatterns[0] . '","serialnummer":"' . $aPatterns[0] . '","chargennummer":"' . $aPatterns[0] . '"}$/u']
                                );

                            } else {

                                $newValidator = $validatorResolver->createValidator(
                                    "TYPO3\\CMS\\Extbase\\Validation\\Validator\\RegularExpressionValidator",
                                    ['regularExpression' => '/^{"zubehoerkategorie":"' . $aPatterns[0] . '","artikelnummer":"' . $aPatterns[0] . '","serialnummer":"","chargennummer":""}$/u']
                                );

                            }

                            $validator->addPropertyValidator(
                                'zubehoer',
                                $newValidator
                            );

                            $newValidator = $validatorResolver->createValidator(
                                "TYPO3\\CMS\\Extbase\\Validation\\Validator\\RegularExpressionValidator",
                                ['regularExpression' => '/^{"geraetebezeichnung":"' . $aPatterns[0] . '","artikelnummer":"' . $aPatterns[0] . '","serialnummer":"' . $aPatterns[0] . '","herstelldatum":"' . $aDatePatterns[0] . '"}$/u']
                            );

                            $validator->addPropertyValidator(
                                'zubehoerBenutztinprodukt',
                                $newValidator
                            );

                        }

                    }

                    if ($request->hasArgument("ersatzteilSelect") && $request->getArgument("ersatzteilSelect") === "1") {

                        $newValidator = $validatorResolver->createValidator(
                            "TYPO3\\CMS\\Extbase\\Validation\\Validator\\RegularExpressionValidator",
                            ['regularExpression' => '/^{"ersatzteilbezeichnung":"' . $aPatterns[0] . '","artikelnummer":"' . $aPatterns[0] . '","serialnummer":"' . $aPatterns[1] . '","chargennummer":"' . $aPatterns[1] . '"}$/u']
                        );

                        $validator->addPropertyValidator(
                            'ersatzteil',
                            $newValidator
                        );

                        $newValidator = $validatorResolver->createValidator(
                            "TYPO3\\CMS\\Extbase\\Validation\\Validator\\RegularExpressionValidator",
                            ['regularExpression' => '/^{"geraetebezeichnung":"' . $aPatterns[0] . '","artikelnummer":"' . $aPatterns[0] . '","serialnummer":"' . $aPatterns[0] . '","herstelldatum":"' . $aDatePatterns[0] . '"}$/u']
                        );

                        $validator->addPropertyValidator(
                            'ersatzteilBenutztinprodukt',
                            $newValidator
                        );

                    }

                    if (isset($aNewReport["fehlermeldungSelect"]) && $aNewReport["fehlermeldungSelect"] === "1") {

                        $aMandatoryFields[] = ['fehlermeldungZeitpunkt']; // pattern already validated in extbase, maybe when converted to datetime object, so only validate empty field here
                        $aMandatoryFields[] = ['fehlerort', $aPatterns[3]]; // validated via Xclass, Do NOT use patterns here
                        $aMandatoryFields[] = ['fehlerBeschreibung', $aPatterns[0]];
                        $aOtherFields[] = ['fehlermeldungCode', $aPatterns[1]];

                    }

                    if (isset($aNewReport["programmSelect"]) && $aNewReport["programmSelect"] === "1") {

                        $aOtherFields[] = ['programmZentrifugeRpm', $aPatterns[1]];
                        $aOtherFields[] = ['programmZentrifugeRcf', $aPatterns[1]];
                        $aOtherFields[] = ['programmZentrifugeLaufzeit', $aPatterns[1]];
                        $aOtherFields[] = ['programmZentrifugeTemp', $aPatterns[1]];
                        $aOtherFields[] = ['programmZentrifugeAnlauf', $aPatterns[1]];
                        $aOtherFields[] = ['programmZentrifugeAuslauf', $aPatterns[1]];

                        $aOtherFields[] = ['programmInkubatorBruttemperatur', $aPatterns[1]];
                        $aOtherFields[] = ['programmInkubatorStartendpunkt', $aPatterns[1]];
                        $aOtherFields[] = ['programmInkubatorBrutzeit', $aPatterns[1]];
                        $aOtherFields[] = ['programmInkubatorAbsenktemperatur', $aPatterns[1]];
                        $aOtherFields[] = ['programmInkubatorExternerkontakt', $aPatterns[1]];
                        $aOtherFields[] = ['programmInkubatorSegmentnummer', $aPatterns[1]];

                    }

                    if (isset($aNewReport["personenschadenSelect"]) && $aNewReport["personenschadenSelect"] === "1") {

                        $aMandatoryFields[] = ['personenschaden', $aPatterns[2]];
                        $aOtherFields[] = ['personenschadenBeschreibung', $aPatterns[1]];

                    }

                    if (isset($aNewReport["kurzschlussSelect"]) && $aNewReport["kurzschlussSelect"] === "1") {

                        $aMandatoryFields[] = ['kurzschluss', $aPatterns[2]];
                        $aOtherFields[] = ['kurzschlussBeschreibung', $aPatterns[1]];

                    }

                    if (isset($aNewReport["crashSelect"]) && $aNewReport["crashSelect"] === "1") {

                        $aMandatoryFields[] = ['crash', $aPatterns[2]];
                        $aOtherFields[] = ['crashBeschreibung', $aPatterns[1]];

                    }

                }

                $aMandatoryFields[] = ['reklamationLogistik', 'BooleanValidator'];

                if (isset($aNewReport["reklamationLogistik"]) && $aNewReport["reklamationLogistik"] === "1") {

                    //$aMandatoryFields[] = ['logistik', $aPatterns[3]];

                    $sRegularExpression = '/^' . $aPatterns[3] . '$/u';

                    $newValidator = $validatorResolver->createValidator(
                        "TEUFELS\\Htc19ExtNonconformityreport\\Validator\\NonTechnicalProblemLogisticsRegularExpressionValidator",
                        ['regularExpression' => $sRegularExpression]
                    );

                    $validator->addPropertyValidator(
                        'logistik',
                        $newValidator
                    );

                    $aOtherFields[] = ['logistikBeschreibung', $aPatterns[1]];

                }

                $aMandatoryFields[] = ['reklamationKundenservice', 'BooleanValidator'];

                if (isset($aNewReport["reklamationKundenservice"]) && $aNewReport["reklamationKundenservice"] === "1") {

                    //$aOtherFields[] = ['kundenservice', $aPatterns[4]];

                    $sRegularExpression = '/^' . $aPatterns[3] . '$/u';

                    $newValidator = $validatorResolver->createValidator(
                        "TEUFELS\\Htc19ExtNonconformityreport\\Validator\\NonTechnicalProblemServiceRegularExpressionValidator",
                        ['regularExpression' => $sRegularExpression]
                    );

                    $validator->addPropertyValidator(
                        'kundenservice',
                        $newValidator
                    );

                    $aOtherFields[] = ['kundenserviceBeschreibung', $aPatterns[1]];

                }

                $aOtherFields[] = ['massnahmen', $aPatterns[4]];

                if ( ! empty($aMandatoryFields)) {
                    foreach ($aMandatoryFields as $aMandatoryField) {

                        $validator->addPropertyValidator(
                            $aMandatoryField[0],
                            $this->objectManager->get('TYPO3\\CMS\\Extbase\\Validation\\Validator\\NotEmptyValidator')
                        );

                        if (array_key_exists(1, $aMandatoryField)) {

                            switch (true) {
                                case $aMandatoryField[1] === 'BooleanValidator':
//                                        $validator->addPropertyValidator(
//                                            $aMandatoryField[0],
//                                            $this->objectManager->get('TYPO3\\CMS\\Extbase\\Validation\\Validator\\BooleanValidator')
//                                        );

                                    switch (true) {
                                        case $aNewReport[$aMandatoryField[0]] !== "1" && $aNewReport[$aMandatoryField[0]] !== "0":
                                            $is = false;
                                            break;
                                        default:
                                            $is = null;
                                    }

                                    $newValidator = $validatorResolver->createValidator(
                                        "TYPO3\\CMS\\Extbase\\Validation\\Validator\\BooleanValidator",
                                        ['is' => $is]
                                    );
                                    $validator->addPropertyValidator(
                                        $aMandatoryField[0],
                                        $newValidator
                                    );

                                    break;
                                case $aMandatoryField[1] === 'EmailAddressValidator':
                                    $validator->addPropertyValidator(
                                        $aMandatoryField[0],
                                        $this->objectManager->get('TYPO3\\CMS\\Extbase\\Validation\\Validator\\EmailAddressValidator')
                                    );
                                    break;
                                default:
                                    $sRegularExpression = '/^' . $aMandatoryField[1] . '$/u';

                                    $newValidator = $validatorResolver->createValidator(
                                        "TYPO3\\CMS\\Extbase\\Validation\\Validator\\RegularExpressionValidator",
                                        ['regularExpression' => $sRegularExpression]
                                    );
                                    $validator->addPropertyValidator(
                                        $aMandatoryField[0],
                                        $newValidator
                                    );
                            }

                        }

                    }
                }

                if ( ! empty($aOtherFields)) {
                    foreach ($aOtherFields as $aOtherField) {

                        if (array_key_exists(1, $aOtherField)) {
                            $newValidator = $validatorResolver->createValidator(
                                "TYPO3\\CMS\\Extbase\\Validation\\Validator\\RegularExpressionValidator",
                                ['regularExpression' => '/^' . $aOtherField[1] . '$/u']
                            );
                            $validator->addPropertyValidator(
                                $aOtherField[0],
                                $newValidator
                            );
                        }

                    }
                }

            }

        }
    }

    /**
     * setTypeConverterConfigurationForImageUpload
     *
     * @param $argumentName
     * @param $refenrenznummer $referenznummer
     */
    protected function setTypeConverterConfigurationForImageUpload($argumentName, $referenznummer)
    {
        $uploadConfiguration = [
            UploadedFileReferenceConverter::CONFIGURATION_ALLOWED_FILE_EXTENSIONS => $GLOBALS['TYPO3_CONF_VARS']['GFX']['imagefile_ext'],
            UploadedFileReferenceConverter::CONFIGURATION_UPLOAD_FOLDER => '2:/' . $referenznummer . '/uploads/'
        ];
        /** @var PropertyMappingConfiguration $newExampleConfiguration */
        $newExampleConfiguration = $this->arguments[$argumentName]->getPropertyMappingConfiguration();
        $newExampleConfiguration->forProperty('upload')->setTypeConverterOptions('TEUFELS\\Htc19ExtNonconformityreport\\Property\\TypeConverter\\UploadedFileReferenceConverter', $uploadConfiguration);
    }

    /**
     * Registers an uploaded file for TYPO3 native upload handling.
     *
     * @param array &$data
     * @param string $namespace
     * @param string $fieldName
     * @param string $targetDirectory
     * @return void
     */
    protected function registerUploadField(array $data, $namespace, $fieldName, $targetDirectory = '1:/_temp_/')
    {
        if (!isset($data['upload'])) {
            $data['upload'] = [];
        }
        $counter = count($data['upload']) + 1;
        $keys = array_keys($_FILES[$namespace]);
        foreach ($keys as $key) {
            $_FILES['upload_' . $counter][$key] = $_FILES[$namespace][$key][$fieldName];
        }
        $data['upload'][$counter] = [
            'data' => $counter,
            'target' => $targetDirectory
        ];
    }

    /**
     * @param $refenrenznummer $referenznummer
     * @param $uploadFile
     * @param $obj
     * @param null $uid
     * @param string $propertyName
     */
    protected function setUpload($referenznummer, $uploadFile, $obj, $uid = null, $propertyName = 'upload')
    {
        /** @var \TYPO3\CMS\Core\Resource\StorageRepository $storageRepository */
        $storageRepository = $this->objectManager->get('TYPO3\\CMS\\Core\\Resource\\StorageRepository');
        $storage = $storageRepository->findByUid('2');
        // 1 ==> default to fileadmin
        $folder = $referenznummer . '/uploads/';
        $targetFolder = null;
        if ($storage->hasFolder($folder)) {
            $targetFolder = $storage->getFolder($folder);
        } else {
            $targetFolder = $storage->createFolder($folder);
        }
        $originalFilePath = $uploadFile['tmp_name'];
        $newFileName = $referenznummer . '_' . $uploadFile['name'];
        if (file_exists($originalFilePath)) {
            $movedNewFile = $storage->addFile($originalFilePath, $targetFolder, $newFileName);
            $newFileReference = $this->objectManager->get('TEUFELS\\Htc19ExtNonconformityreport\\Domain\\Model\\FileReference');
            $newFileReference->setFile($movedNewFile);
            //$method = 'set' . ucfirst($propertyName);   // dem Obj. eine FileReference hinzufügen
            //$obj->{$method}($newFileReference);
            $obj->addUpload($newFileReference);
        }
    }

    /**
     * @param $referenznummer
     * @param $zip_name
     */
    protected function zipUpload($referenznummer, $zip_name)
    {
        /** @var \TYPO3\CMS\Core\Resource\StorageRepository $storageRepository */
        $storageRepository = $this->objectManager->get('TYPO3\\CMS\\Core\\Resource\\StorageRepository');
        $storage = $storageRepository->findByUid('2');
        // 1 ==> default to fileadmin
        $folder = $referenznummer . '/uploads';
        if ($storage->hasFolder($folder)) {
            $targetFolder = $storage->getFolder($folder);
            $upload_dir = realpath($targetFolder->getPublicUrl());
            //this folder must be writeable by the server
            $zip_dir = realpath($targetFolder->getPublicUrl() . '..');
            $zip_file = $zip_dir . '/' . $zip_name;
            //var_dump("zipUpload :: upload DIR: " . $upload_dir) . "\n";
            //var_dump("zipUpload :: zip FILE: " . $zip_file) . "\n";
            // Initialize archive object
            $zip = new \ZipArchive();
            $zip->open($zip_file, \ZipArchive::CREATE | \ZipArchive::OVERWRITE);
            // Create recursive directory iterator
            /** @var SplFileInfo[] $files */
            $files = new \RecursiveIteratorIterator(new \RecursiveDirectoryIterator($upload_dir), \RecursiveIteratorIterator::LEAVES_ONLY);
            foreach ($files as $name => $file) {
                // Skip directories (they would be added automatically)
                if (!$file->isDir()) {
                    // Get real and relative path for current file
                    $filePath = $file->getRealPath();
                    $relativePath = substr($filePath, strlen($upload_dir) + 1);
                    // Add current file to archive
                    $zip->addFile($filePath, $relativePath);
                }
            }
            // Zip archive will be created only after closing object
            $zip->close();
        }
    }

    /**
     * @param \TEUFELS\Htc19ExtNonconformityreport\Domain\Model\Report $newReport
     */
    protected function exportXML(\TEUFELS\Htc19ExtNonconformityreport\Domain\Model\Report $newReport)
    {
        //Create DOM
        $dom = new CustomDOMDocument();
        $dom->encoding = 'utf-8';
        $dom->xmlVersion = '1.0';
        $dom->formatOutput = true;
        //Get Storage Path
        /** @var \TYPO3\CMS\Core\Resource\StorageRepository $storageRepository */
        $storageRepository = $this->objectManager->get('TYPO3\\CMS\\Core\\Resource\\StorageRepository');
        $storage = $storageRepository->findByUid('2');
        // 1 ==> default to fileadmin
        $folder = $newReport->getReferenznummer();
        $targetFolder = null;
        if ($storage->hasFolder($folder)) {
            $targetFolder = $storage->getFolder($folder);
        } else {
            $targetFolder = $storage->createFolder($folder);
        }
        //this folder must be writeable by the server
        $xml_folder = realpath($targetFolder->getPublicUrl());
        $xml_file_name = $newReport->getReferenznummer() . '.xml';
        //Create DOM Tree Report
        $root = $dom->createElement('Reports');
        $report_node = $dom->createElement('report');
        $attr_report_id = new \DOMAttr('id', $newReport->getReferenznummer());
        $report_node->setAttributeNode($attr_report_id);
        //Basis Daten
        $child_node_referenznummer = $dom->createElement('referenznummer', $newReport->getReferenznummer());
        $report_node->appendChild($child_node_referenznummer);
        $sReklamationdatum = (string) $newReport->getReklamationsdatum()->format('Y-m-d');
        $child_node_reklamationsdatum = $dom->createElement('reklamationsdatum', $sReklamationdatum);
        $report_node->appendChild($child_node_reklamationsdatum);
        //Erfasser Daten
        $child_node_erfasser = $dom->createElement('erfasser');
        if ($newReport->getErfasserSelect() == 'endkunde') {
            //Händler Daten = empty
            $child_node_haendler = $dom->createElement('haendler');
            $child_node_erfasser->appendChild($child_node_haendler);
            //Meldender Daten = empty
            $child_node_meldender = $dom->createElement('meldender');
            $child_node_erfasser->appendChild($child_node_meldender);
            //Endkunde Daten
            $child_node_endkunde = $dom->createElement('endkunde');
            $child_node_endkunde_name = $dom->createElement('name', $newReport->getEndkundeName());
            $child_node_endkunde_telefon = $dom->createElement('telefon', $newReport->getEndkundeTelefon());
            $child_node_endkunde_email = $dom->createElement('email', $newReport->getEndkundeEmail());
            $child_node_endkunde_adresse = $dom->createElementWithText('adresse', $newReport->getEndkundeAdresse());
            $child_node_endkunde->appendChild($child_node_endkunde_name);
            $child_node_endkunde->appendChild($child_node_endkunde_telefon);
            $child_node_endkunde->appendChild($child_node_endkunde_email);
            $child_node_endkunde->appendChild($child_node_endkunde_adresse);
            $child_node_erfasser->appendChild($child_node_endkunde);
        } else {
            //Händler Daten
            $child_node_haendler = $dom->createElement('haendler');
            $child_node_haendler_nummer = $dom->createElement('kundennummer', $newReport->getKundeNummer());
            $child_node_haendler_name = $dom->createElement('kundenname', $newReport->getKundeName());
            $child_node_haendler_telefon = $dom->createElement('telefon', $newReport->getKundeTelefon());
            $child_node_haendler_email = $dom->createElement('email', $newReport->getKundeEmail());
            $child_node_haendler_adresse = $dom->createElementWithText('adresse', $newReport->getKundeAdresse());
            $child_node_haendler->appendChild($child_node_haendler_nummer);
            $child_node_haendler->appendChild($child_node_haendler_name);
            $child_node_haendler->appendChild($child_node_haendler_telefon);
            $child_node_haendler->appendChild($child_node_haendler_email);
            $child_node_haendler->appendChild($child_node_haendler_adresse);
            $child_node_erfasser->appendChild($child_node_haendler);
            //Meldender Daten
            $child_node_meldender = $dom->createElement('meldender');
            if ($newReport->getMeldenderName() && $newReport->getMeldenderName() != '') {
                $child_node_meldender_name = $dom->createElement('name', $newReport->getMeldenderName());
                $child_node_meldender_kontakt = $dom->createElementWithText('kontakt', $newReport->getMeldenderKontakt());
                $child_node_meldender->appendChild($child_node_meldender_name);
                $child_node_meldender->appendChild($child_node_meldender_kontakt);
            }
            $child_node_erfasser->appendChild($child_node_meldender);
            //Endkunde Daten
            $child_node_endkunde = $dom->createElement('endkunde');
            if ($newReport->isEndkundeAbweichend()) {
                $child_node_endkunde_name = $dom->createElement('name', $newReport->getEndkundeName());
                $child_node_endkunde_telefon = $dom->createElement('telefon', $newReport->getEndkundeTelefon());
                $child_node_endkunde_email = $dom->createElement('email', $newReport->getEndkundeEmail());
                $child_node_endkunde_adresse = $dom->createElementWithText('adresse', $newReport->getEndkundeAdresse());
                $child_node_endkunde->appendChild($child_node_endkunde_name);
                $child_node_endkunde->appendChild($child_node_endkunde_telefon);
                $child_node_endkunde->appendChild($child_node_endkunde_email);
                $child_node_endkunde->appendChild($child_node_endkunde_adresse);
            }
            $child_node_erfasser->appendChild($child_node_endkunde);
        }
        $report_node->appendChild($child_node_erfasser);
        //START Reklamation ------------------------------------------------
        $child_node_reklamation = $dom->createElement('reklamation');
        //Reklamation - Technisches Problem
        $child_node_reklamation_technisch = $dom->createElement('technisch');
        if ($newReport->isReklamationTechnisch()) {
            //Gerät
            $child_node_reklamation_technisch_produkt = $dom->createElementWithJSON('geraet', $newReport->getProdukt());
            //Gerät: Details defekte Komponente
            $child_node_reklamation_technisch_defektekomponente = $dom->createElementWithJSON('defekte-komponente', $newReport->getDefektekomponente());
            $child_node_reklamation_technisch_produkt->appendChild($child_node_reklamation_technisch_defektekomponente);
            $child_node_reklamation_technisch->appendChild($child_node_reklamation_technisch_produkt);
            //Zubehör
            $child_node_reklamation_technisch_zubehoer = $dom->createElementWithJSON('zubehoer', $newReport->getZubehoer());
            //Zubehör: Benutzt in Produkt
            $child_node_reklamation_technisch_zubehoer_benutztinprodukt = $dom->createElementWithJSON('benutzt-in-geraet', $newReport->getZubehoerBenutztinprodukt());
            $child_node_reklamation_technisch_zubehoer->appendChild($child_node_reklamation_technisch_zubehoer_benutztinprodukt);
            $child_node_reklamation_technisch->appendChild($child_node_reklamation_technisch_zubehoer);
            //Ersatzteil
            $child_node_reklamation_technisch_ersatzteil = $dom->createElementWithJSON('ersatzteil', $newReport->getErsatzteil());
            //Ersatzteil: Benutzt in Produkt
            $child_node_reklamation_technisch_ersatzteil_benutztinprodukt = $dom->createElementWithJSON('benutzt-in-geraet', $newReport->getErsatzteilBenutztinprodukt());
            $child_node_reklamation_technisch_ersatzteil->appendChild($child_node_reklamation_technisch_ersatzteil_benutztinprodukt);
            $child_node_reklamation_technisch->appendChild($child_node_reklamation_technisch_ersatzteil);
            //Fehlermeldung
            $child_node_reklamation_technisch_fehlermeldung = $dom->createElement('fehlerbeschreibung');
            if ($newReport->isFehlermeldungSelect()) {
                //Datum Auftreten
                $sFehlermeldungZeitpunkt = (string) $newReport->getFehlermeldungZeitpunkt()->format('Y-m-d');
                $child_node_reklamation_technisch_fehlermeldung_zeitpunkt = $dom->createElement('zeitpunkt-auftreten', $sFehlermeldungZeitpunkt);
                $child_node_reklamation_technisch_fehlermeldung->appendChild($child_node_reklamation_technisch_fehlermeldung_zeitpunkt);
                //Fehlerort
                $aFehlerort = $newReport->getFehlerort();
                $sFehlerort = implode(';', $aFehlerort);
                $child_node_reklamation_technisch_fehlerort = $dom->createElementWithText('fehlerort', $sFehlerort);
                $child_node_reklamation_technisch_fehlermeldung->appendChild($child_node_reklamation_technisch_fehlerort);
                //Detailierte Fehlerberschreibung
                $child_node_reklamation_technisch_fehlerbeschreibung = $dom->createElementWithText('detaillierte-fehlerbeschreibung', $newReport->getFehlerBeschreibung());
                $child_node_reklamation_technisch_fehlermeldung->appendChild($child_node_reklamation_technisch_fehlerbeschreibung);
                //Datei Upload
                $child_node_reklamation_technisch_upload = $dom->createElement('upload');
                if ($newReport->getUpload() > 0) {
                    //pfad
                    $url = $actual_link = (isset($_SERVER['HTTPS']) && $_SERVER['HTTPS'] === 'on' ? 'https' : 'http') . '://' . $_SERVER['SERVER_NAME'];
                    $path = $url . '/reports/' . $newReport->getReferenznummer() . '/upload.zip';
                    $child_node_reklamation_technisch_upload_pfad = $dom->createElement('pfad', $path);
                    $child_node_reklamation_technisch_upload->appendChild($child_node_reklamation_technisch_upload_pfad);
                    //anzahl dateien
                    $child_node_reklamation_technisch_upload_count = $dom->createElement('dateien', count($newReport->getUpload()));
                    $child_node_reklamation_technisch_upload->appendChild($child_node_reklamation_technisch_upload_count);
                }
                $child_node_reklamation_technisch_fehlermeldung->appendChild($child_node_reklamation_technisch_upload);
                //Error-Code
                $child_node_reklamation_technisch_fehlermeldung_errorcode = $dom->createElementWithText('error-code', $newReport->getFehlermeldungCode());
                $child_node_reklamation_technisch_fehlermeldung->appendChild($child_node_reklamation_technisch_fehlermeldung_errorcode);
            }
            $child_node_reklamation_technisch->appendChild($child_node_reklamation_technisch_fehlermeldung);
            //Programm
            $child_node_reklamation_technisch_programm = $dom->createElement('bei-programm');
            if ($newReport->isProgrammSelect()) {
                //zentrifuge
                $child_node_reklamation_technisch_programm_zentrifuge = $dom->createElement('zentrifuge');
                $child_node_reklamation_technisch_programm_zentrifuge_rpm = $dom->createElementWithText('rpm', $newReport->getProgrammZentrifugeRpm());
                $child_node_reklamation_technisch_programm_zentrifuge_rcf = $dom->createElementWithText('rcf', $newReport->getProgrammZentrifugeRcf());
                $child_node_reklamation_technisch_programm_zentrifuge_laufzeit = $dom->createElementWithText('laufzeit', $newReport->getProgrammZentrifugeLaufzeit());
                $child_node_reklamation_technisch_programm_zentrifuge_temp = $dom->createElementWithText('temperatur', $newReport->getProgrammZentrifugeTemp());
                $child_node_reklamation_technisch_programm_zentrifuge_anlauf = $dom->createElementWithText('anlauf', $newReport->getProgrammZentrifugeAnlauf());
                $child_node_reklamation_technisch_programm_zentrifuge_auslauf = $dom->createElementWithText('auslauf', $newReport->getProgrammZentrifugeAuslauf());
                $child_node_reklamation_technisch_programm_zentrifuge->appendChild($child_node_reklamation_technisch_programm_zentrifuge_rpm);
                $child_node_reklamation_technisch_programm_zentrifuge->appendChild($child_node_reklamation_technisch_programm_zentrifuge_rcf);
                $child_node_reklamation_technisch_programm_zentrifuge->appendChild($child_node_reklamation_technisch_programm_zentrifuge_laufzeit);
                $child_node_reklamation_technisch_programm_zentrifuge->appendChild($child_node_reklamation_technisch_programm_zentrifuge_temp);
                $child_node_reklamation_technisch_programm_zentrifuge->appendChild($child_node_reklamation_technisch_programm_zentrifuge_anlauf);
                $child_node_reklamation_technisch_programm_zentrifuge->appendChild($child_node_reklamation_technisch_programm_zentrifuge_auslauf);
                $child_node_reklamation_technisch_programm->appendChild($child_node_reklamation_technisch_programm_zentrifuge);
                //inkubator
                $child_node_reklamation_technisch_programm_inkubator = $dom->createElement('inkubator');
                $child_node_reklamation_technisch_programm_inkubator_bruttemperatur = $dom->createElementWithText('bruttemperatur', $newReport->getProgrammInkubatorBruttemperatur());
                $child_node_reklamation_technisch_programm_inkubator_startendpunkt = $dom->createElementWithText('startendpunkt', $newReport->getProgrammInkubatorStartendpunkt());
                $child_node_reklamation_technisch_programm_inkubator_brutzeit = $dom->createElementWithText('brutzeit', $newReport->getProgrammInkubatorBrutzeit());
                $child_node_reklamation_technisch_programm_inkubator_absenktemperatur = $dom->createElementWithText('absenktemperatur', $newReport->getProgrammInkubatorAbsenktemperatur());
                $child_node_reklamation_technisch_programm_inkubator_externerkontakt = $dom->createElementWithText('externer-kontakt', $newReport->getProgrammInkubatorExternerkontakt());
                $child_node_reklamation_technisch_programm_inkubator_segmentnummer = $dom->createElementWithText('segmentnummer', $newReport->getProgrammInkubatorSegmentnummer());
                $child_node_reklamation_technisch_programm_inkubator->appendChild($child_node_reklamation_technisch_programm_inkubator_bruttemperatur);
                $child_node_reklamation_technisch_programm_inkubator->appendChild($child_node_reklamation_technisch_programm_inkubator_startendpunkt);
                $child_node_reklamation_technisch_programm_inkubator->appendChild($child_node_reklamation_technisch_programm_inkubator_brutzeit);
                $child_node_reklamation_technisch_programm_inkubator->appendChild($child_node_reklamation_technisch_programm_inkubator_absenktemperatur);
                $child_node_reklamation_technisch_programm_inkubator->appendChild($child_node_reklamation_technisch_programm_inkubator_externerkontakt);
                $child_node_reklamation_technisch_programm_inkubator->appendChild($child_node_reklamation_technisch_programm_inkubator_segmentnummer);
                $child_node_reklamation_technisch_programm->appendChild($child_node_reklamation_technisch_programm_inkubator);
            }
            $child_node_reklamation_technisch->appendChild($child_node_reklamation_technisch_programm);
            //Personenschäden
            $child_node_reklamation_technisch_personenschaden = $dom->createElement('personenschaden');
            if ($newReport->isPersonenschadenSelect()) {
                $aPersonenschaden = $newReport->getPersonenschaden();
                $sPersonenschaden = implode(';', $aPersonenschaden);
                $child_node_reklamation_technisch_personenschaden_betreffend = $dom->createElementWithText('betreffend', $sPersonenschaden);
                $child_node_reklamation_technisch_personenschaden_beschreibung = $dom->createElementWithText('beschreibung', $newReport->getPersonenschadenBeschreibung());
                $child_node_reklamation_technisch_personenschaden->appendChild($child_node_reklamation_technisch_personenschaden_betreffend);
                $child_node_reklamation_technisch_personenschaden->appendChild($child_node_reklamation_technisch_personenschaden_beschreibung);
            }
            $child_node_reklamation_technisch->appendChild($child_node_reklamation_technisch_personenschaden);
            //Kurzschluss
            $child_node_reklamation_technisch_kurzschluss = $dom->createElement('kurzschluss');
            if ($newReport->isKurzschlussSelect()) {
                $aKurzschluss = $newReport->getKurzschluss();
                $sKurzschluss = implode(';', $aKurzschluss);
                $child_node_reklamation_technisch_kurzschluss_betreffend = $dom->createElementWithText('betreffend', $sKurzschluss);
                $child_node_reklamation_technisch_kurzschluss_beschreibung = $dom->createElementWithText('beschreibung', $newReport->getKurzschlussBeschreibung());
                $child_node_reklamation_technisch_kurzschluss->appendChild($child_node_reklamation_technisch_kurzschluss_betreffend);
                $child_node_reklamation_technisch_kurzschluss->appendChild($child_node_reklamation_technisch_kurzschluss_beschreibung);
            }
            $child_node_reklamation_technisch->appendChild($child_node_reklamation_technisch_kurzschluss);
            //Crash
            $child_node_reklamation_technisch_crash = $dom->createElement('crash');
            if ($newReport->isCrashSelect()) {
                $aCrash = $newReport->getCrash();
                $sCrash = implode(';', $aCrash);
                $child_node_reklamation_technisch_crash_betreffend = $dom->createElementWithText('betreffend', $sCrash);
                $child_node_reklamation_technisch_crash_beschreibung = $dom->createElementWithText('beschreibung', $newReport->getCrashBeschreibung());
                $child_node_reklamation_technisch_crash->appendChild($child_node_reklamation_technisch_crash_betreffend);
                $child_node_reklamation_technisch_crash->appendChild($child_node_reklamation_technisch_crash_beschreibung);
            }
            $child_node_reklamation_technisch->appendChild($child_node_reklamation_technisch_crash);
        }
        $child_node_reklamation->appendChild($child_node_reklamation_technisch);
        //Reklamation - Nicht Technisch - Logistik
        $child_node_reklamation_logistik = $dom->createElement('logistik');
        if ($newReport->isReklamationLogistik()) {
            $aLogistik = $newReport->getLogistik();
            $sLogistik = implode(';', $aLogistik);
            $child_node_reklamation_logistik_betreffend = $dom->createElementWithText('betreffend', $sLogistik);
            $child_node_reklamation_logistik_beschreibung = $dom->createElementWithText('beschreibung', $newReport->getLogistikBeschreibung());
            $child_node_reklamation_logistik->appendChild($child_node_reklamation_logistik_betreffend);
            $child_node_reklamation_logistik->appendChild($child_node_reklamation_logistik_beschreibung);
        }
        $child_node_reklamation->appendChild($child_node_reklamation_logistik);
        //Reklamation - Nicht Technisch - Kundenservice
        $child_node_reklamation_kundenservice = $dom->createElement('kundenservice');
        if ($newReport->isReklamationKundenservice()) {
            $aKundenservice = $newReport->getKundenservice();
            $sKundenservice = implode(';', $aKundenservice);
            $child_node_reklamation_kundenservice_betreffend = $dom->createElementWithText('betreffend', $sKundenservice);
            $child_node_reklamation_kundenservice_beschreibung = $dom->createElementWithText('beschreibung', $newReport->getKundenserviceBeschreibung());
            $child_node_reklamation_kundenservice->appendChild($child_node_reklamation_kundenservice_betreffend);
            $child_node_reklamation_kundenservice->appendChild($child_node_reklamation_kundenservice_beschreibung);
        }
        $child_node_reklamation->appendChild($child_node_reklamation_kundenservice);
        //append Reklamation
        $report_node->appendChild($child_node_reklamation);
        //END Reklamation --------------------------------------------------
        //Massnahmen "Sie wünschen..."
        $aMassnahmen = $newReport->getMassnahmen();
        $sMassnahmen = implode(';', $aMassnahmen);
        $child_node_massnahmen = $dom->createElementWithText('massnahmen', $sMassnahmen);
        $report_node->appendChild($child_node_massnahmen);
        //Append Data to DOM
        $root->appendChild($report_node);
        $dom->appendChild($root);
        //Save XML
        $dom->save($xml_folder . '/' . $xml_file_name);

        $host = $_SERVER['TYPO3_CONTEXT'] === "Development/Docker" ? 'http://apache2' : 'https://' . $_SERVER['HTTP_HOST'];

        // URL to the login page
        $loginUrl = $host . $this->uriBuilder
        ->reset()
        ->setTargetPageUid(1) // or set specific page id
        ->uriFor(
            'login', 
            [], 
            'Login', 
            'Felogin', 
            'Login'
        ); 

        // Login credentials
        $loginCredentials = [
            'user' => '_guzzle',
            'pass' => 'ha6woovaiG1eih_ohs8ouceepe{h4Koh1iesheeP7desaew'
        ];
        
        // URL to the show action page
        $showUrl = $host . $this->uriBuilder
        ->reset()
        ->setTargetPageUid($GLOBALS['TSFE']->id) // or set specific page id
        ->uriFor(
            'show', 
            ['report' => $newReport->getUid()], 
            'Report', 
            'Htc19ExtNonconformityreport', 
            'Htc19extnonconformityreportnew'
        ); 

        // Fetch the protected content
        try {
            $htmlContent = $this->fetchProtectedContent($loginUrl, $loginCredentials, $showUrl);
            
            // Define the path where the HTML file will be saved
            $filePath = $xml_folder . '/' . str_replace('.xml', '', $xml_file_name) . '.html';

            // Save the HTML content to a file
            file_put_contents($filePath, $htmlContent);
            
        } catch (\Exception $e) {

            $htmlContent = $e->getMessage();

            $filePath = $xml_folder . '/' . str_replace('.xml', '', $xml_file_name) . '.html';

            file_put_contents($filePath, $htmlContent);

        }
        
    }

    /**
     * Login and fetch protected content
     *
     * @param string $loginUrl
     * @param array $loginCredentials
     * @param string $protectedUrl
     * @return string
     */
    protected function fetchProtectedContent($loginUrl, $loginCredentials, $protectedUrl)
    {
        $client = new Client([
            'cookies' => true, // Enable cookies for session management
            'http_errors' => false, // Prevent Guzzle from throwing exceptions on HTTP errors
        ]);

        $postData = [
            'user' => $loginCredentials['user'],
            'pass' =>$loginCredentials['pass'],
            'logintype' => 'login',
            'pid' => 10,
            // 'redirect_url' => '', // Optionally set a redirect URL after login
        ];

        // Login to the TYPO3 frontend
        $response = $client->post($loginUrl, [
            'form_params' => $postData
        ]);

        // Check if login was successful
        if ($response->getStatusCode() !== 200) {
            return 'Failed to log in _guzzle user';
        }

        // Fetch the protected content
        $response = $client->get($protectedUrl);

        if ($response->getStatusCode() !== 200) {
            return 'Failed to fetch protected content';
        }

        return $response->getBody()->getContents();
    }

}

class CustomDOMDocument extends \DOMDocument {

    function createElementWithText($name, $child_text) {

        /**
         * Creates an element with a child text node
         *
         * @param  string  $name        element tag name
         * @param  string  $child_text  child node text
         * @return  object  new element
         */

        $element = $this->createElement($name);

        $element_text = $this->createTextNode( nl2br($child_text) );
        $element->appendChild($element_text);

        return $element;
    }

    function createElementWithJSON($name, $child_json) {

        $element = $this->createElement($name);

        $object = json_decode($child_json);

        foreach ($object as $key => $value) {
            $element_object = $this->createElement($key, (string)$value);
            $element->appendChild($element_object);
        }

        return $element;

    }
}