<?php
namespace TEUFELS\Htc19ExtNonconformityreport\Domain\Model;

/***
 *
 * This file is part of the "htc19_ext_nonconformityreport" Extension for TYPO3 CMS.
 *
 * For the full copyright and license information, please read the
 * LICENSE.txt file that was distributed with this source code.
 *
 *  (c) 2019 Bastian Holzem <b.holzem@teufels.com>, teufels GmbH
 *
 ***/

/**
 * Report
 */
class Report extends \TYPO3\CMS\Extbase\DomainObject\AbstractEntity
{
    /**
     * referenznummer
     *
     * @var int
     */
    protected $referenznummer = 0;

    /**
     * reklamationsdatum
     *
     * @var \DateTime
     */
    protected $reklamationsdatum = null;

    /**
     * erfasserSelect
     *
     * @var string
     */
    protected $erfasserSelect = '';

    /**
     * kundeNummer
     *
     * @var string
     */
    protected $kundeNummer = '';

    /**
     * kundeName
     *
     * @var string
     */
    protected $kundeName = '';

    /**
     * kundeTelefon
     *
     * @var string
     */
    protected $kundeTelefon = '';

    /**
     * kundeEmail
     *
     * @var string
     */
    protected $kundeEmail = '';

    /**
     * kundeAdresse
     *
     * @var string
     */
    protected $kundeAdresse = '';

    /**
     * meldenderName
     *
     * @var string
     */
    protected $meldenderName = '';

    /**
     * meldenderKontakt
     *
     * @var string
     */
    protected $meldenderKontakt = '';

    /**
     * endkundeAbweichend
     *
     * @var bool
     */
    protected $endkundeAbweichend = false;

    /**
     * endkundeName
     *
     * @var string
     */
    protected $endkundeName = '';

    /**
     * endkundeTelefon
     *
     * @var string
     */
    protected $endkundeTelefon = '';

    /**
     * endkundeEmail
     *
     * @var string
     */
    protected $endkundeEmail = '';

    /**
     * endkundeAdresse
     *
     * @var string
     */
    protected $endkundeAdresse = '';

    /**
     * reklamationTechnisch
     *
     * @var bool
     */
    protected $reklamationTechnisch = false;

    /**
     * produkt
     *
     * @var string
     */
    protected $produkt = '';

    /**
     * zubehoer
     *
     * @var string
     */
    protected $zubehoer = '';

    /**
     * zubehoerBenutztinprodukt
     *
     * @var string
     */
    protected $zubehoerBenutztinprodukt = '';

    /**
     * ersatzteil
     *
     * @var string
     */
    protected $ersatzteil = '';

    /**
     * ersatzteilBenutztinprodukt
     *
     * @var string
     */
    protected $ersatzteilBenutztinprodukt = '';

    /**
     * fehlerort
     *
     * @var string
     */
    protected $fehlerort = '';

    /**
     * fehlermeldungSelect
     *
     * @var bool
     */
    protected $fehlermeldungSelect = false;

    /**
     * fehlermeldungCode
     *
     * @var string
     */
    protected $fehlermeldungCode = '';

    /**
     * fehlermeldungZeitpunkt
     *
     * @var \DateTime
     */
    protected $fehlermeldungZeitpunkt = '';

    /**
     * defektekomponenteSelect
     *
     * @var bool
     */
    protected $defektekomponenteSelect = false;

    /**
     * defektekomponente
     *
     * @var string
     */
    protected $defektekomponente = '';

    /**
     * programmSelect
     *
     * @var bool
     */
    protected $programmSelect = false;

    /**
     * programmZentrifugeRpm
     *
     * @var string
     */
    protected $programmZentrifugeRpm = '';

    /**
     * programmZentrifugeRcf
     *
     * @var string
     */
    protected $programmZentrifugeRcf = '';

    /**
     * programmZentrifugeLaufzeit
     *
     * @var string
     */
    protected $programmZentrifugeLaufzeit = '';

    /**
     * programmZentrifugeTemp
     *
     * @var string
     */
    protected $programmZentrifugeTemp = '';

    /**
     * programmZentrifugeAnlauf
     *
     * @var string
     */
    protected $programmZentrifugeAnlauf = '';

    /**
     * programmZentrifugeAuslauf
     *
     * @var string
     */
    protected $programmZentrifugeAuslauf = '';

    /**
     * programmInkubatorBruttemperatur
     *
     * @var string
     */
    protected $programmInkubatorBruttemperatur = '';

    /**
     * programmInkubatorStartendpunkt
     *
     * @var string
     */
    protected $programmInkubatorStartendpunkt = '';

    /**
     * programmInkubatorBrutzeit
     *
     * @var string
     */
    protected $programmInkubatorBrutzeit = '';

    /**
     * programmInkubatorAbsenktemperatur
     *
     * @var string
     */
    protected $programmInkubatorAbsenktemperatur = '';

    /**
     * programmInkubatorExternerkontakt
     *
     * @var string
     */
    protected $programmInkubatorExternerkontakt = '';

    /**
     * programmInkubatorSegmentnummer
     *
     * @var string
     */
    protected $programmInkubatorSegmentnummer = '';

    /**
     * fehlerBeschreibung
     *
     * @var string
     */
    protected $fehlerBeschreibung = '';

    /**
     * personenschadenSelect
     *
     * @var bool
     */
    protected $personenschadenSelect = false;

    /**
     * personenschaden
     *
     * @var string
     */
    protected $personenschaden = '';

    /**
     * personenschadenBeschreibung
     *
     * @var string
     */
    protected $personenschadenBeschreibung = '';

    /**
     * crashSelect
     *
     * @var bool
     */
    protected $crashSelect = false;

    /**
     * crash
     *
     * @var string
     */
    protected $crash = '';

    /**
     * crashBeschreibung
     *
     * @var string
     */
    protected $crashBeschreibung = '';

    /**
     * kurzschlussSelect
     *
     * @var bool
     */
    protected $kurzschlussSelect = false;

    /**
     * kurzschluss
     *
     * @var string
     */
    protected $kurzschluss = '';

    /**
     * kurzschlussBeschreibung
     *
     * @var string
     */
    protected $kurzschlussBeschreibung = '';

    /**
     * reklamationLogistik
     *
     * @var bool
     */
    protected $reklamationLogistik = false;

    /**
     * logistik
     *
     * @var string
     */
    protected $logistik = '';

    /**
     * logistikBeschreibung
     *
     * @var string
     */
    protected $logistikBeschreibung = '';

    /**
     * reklamationKundenservice
     *
     * @var bool
     */
    protected $reklamationKundenservice = false;

    /**
     * kundenservice
     *
     * @var string
     */
    protected $kundenservice = '';

    /**
     * kundenserviceBeschreibung
     *
     * @var string
     */
    protected $kundenserviceBeschreibung = '';

    /**
     * massnahmen
     *
     * @var string
     */
    protected $massnahmen = '';

    /**
     * upload
     *
     * @var \TYPO3\CMS\Extbase\Persistence\ObjectStorage<\TYPO3\CMS\Extbase\Domain\Model\FileReference>
     * @TYPO3\CMS\Extbase\Annotation\ORM\Cascade remove
     */
    protected $upload = null;

    /**
     * Returns the referenznummer
     *
     * @return int $referenznummer
     */
    public function getReferenznummer()
    {
        return $this->referenznummer;
    }

    /**
     * Sets the referenznummer
     *
     * @param int $referenznummer
     * @return void
     */
    public function setReferenznummer($referenznummer)
    {
        $this->referenznummer = $referenznummer;
    }

    /**
     * Returns the reklamationsdatum
     *
     * @return \DateTime $reklamationsdatum
     */
    public function getReklamationsdatum()
    {
        return $this->reklamationsdatum;
    }

    /**
     * Sets the reklamationsdatum
     *
     * @param \DateTime $reklamationsdatum
     * @return void
     */
    public function setReklamationsdatum(\DateTime $reklamationsdatum)
    {
        $this->reklamationsdatum = $reklamationsdatum;
    }

    /**
     * Returns the kundeNummer
     *
     * @return string $kundeNummer
     */
    public function getKundeNummer()
    {
        return $this->kundeNummer;
    }

    /**
     * Sets the kundeNummer
     *
     * @param string $kundeNummer
     * @return void
     */
    public function setKundeNummer($kundeNummer)
    {
        $this->kundeNummer = $kundeNummer;
    }

    /**
     * Returns the kundeName
     *
     * @return string $kundeName
     */
    public function getKundeName()
    {
        return $this->kundeName;
    }

    /**
     * Sets the kundeName
     *
     * @param string $kundeName
     * @return void
     */
    public function setKundeName($kundeName)
    {
        $this->kundeName = $kundeName;
    }

    /**
     * Returns the kundeTelefon
     *
     * @return string $kundeTelefon
     */
    public function getKundeTelefon()
    {
        return $this->kundeTelefon;
    }

    /**
     * Sets the kundeTelefon
     *
     * @param string $kundeTelefon
     * @return void
     */
    public function setKundeTelefon($kundeTelefon)
    {
        $this->kundeTelefon = $kundeTelefon;
    }

    /**
     * Returns the kundeEmail
     *
     * @return string $kundeEmail
     */
    public function getKundeEmail()
    {
        return $this->kundeEmail;
    }

    /**
     * Sets the kundeEmail
     *
     * @param string $kundeEmail
     * @return void
     */
    public function setKundeEmail($kundeEmail)
    {
        $this->kundeEmail = $kundeEmail;
    }

    /**
     * Returns the kundeAdresse
     *
     * @return string $kundeAdresse
     */
    public function getKundeAdresse()
    {
        return $this->kundeAdresse;
    }

    /**
     * Sets the kundeAdresse
     *
     * @param string $kundeAdresse
     * @return void
     */
    public function setKundeAdresse($kundeAdresse)
    {
        $this->kundeAdresse = $kundeAdresse;
    }

    /**
     * Returns the meldenderName
     *
     * @return string $meldenderName
     */
    public function getMeldenderName()
    {
        return $this->meldenderName;
    }

    /**
     * Sets the meldenderName
     *
     * @param string $meldenderName
     * @return void
     */
    public function setMeldenderName($meldenderName)
    {
        $this->meldenderName = $meldenderName;
    }

    /**
     * Returns the meldenderKontakt
     *
     * @return string $meldenderKontakt
     */
    public function getMeldenderKontakt()
    {
        return $this->meldenderKontakt;
    }

    /**
     * Sets the meldenderKontakt
     *
     * @param string $meldenderKontakt
     * @return void
     */
    public function setMeldenderKontakt($meldenderKontakt)
    {
        $this->meldenderKontakt = $meldenderKontakt;
    }

    /**
     * Returns the endkundeAbweichend
     *
     * @return bool $endkundeAbweichend
     */
    public function getEndkundeAbweichend()
    {
        return $this->endkundeAbweichend;
    }

    /**
     * Sets the endkundeAbweichend
     *
     * @param bool $endkundeAbweichend
     * @return void
     */
    public function setEndkundeAbweichend($endkundeAbweichend)
    {
        $this->endkundeAbweichend = $endkundeAbweichend;
    }

    /**
     * Returns the boolean state of endkundeAbweichend
     *
     * @return bool
     */
    public function isEndkundeAbweichend()
    {
        return $this->endkundeAbweichend;
    }

    /**
     * Returns the endkundeName
     *
     * @return string $endkundeName
     */
    public function getEndkundeName()
    {
        return $this->endkundeName;
    }

    /**
     * Sets the endkundeName
     *
     * @param string $endkundeName
     * @return void
     */
    public function setEndkundeName($endkundeName)
    {
        $this->endkundeName = $endkundeName;
    }

    /**
     * Returns the endkundeTelefon
     *
     * @return string $endkundeTelefon
     */
    public function getEndkundeTelefon()
    {
        return $this->endkundeTelefon;
    }

    /**
     * Sets the endkundeTelefon
     *
     * @param string $endkundeTelefon
     * @return void
     */
    public function setEndkundeTelefon($endkundeTelefon)
    {
        $this->endkundeTelefon = $endkundeTelefon;
    }

    /**
     * Returns the endkundeEmail
     *
     * @return string $endkundeEmail
     */
    public function getEndkundeEmail()
    {
        return $this->endkundeEmail;
    }

    /**
     * Sets the endkundeEmail
     *
     * @param string $endkundeEmail
     * @return void
     */
    public function setEndkundeEmail($endkundeEmail)
    {
        $this->endkundeEmail = $endkundeEmail;
    }

    /**
     * Returns the endkundeAdresse
     *
     * @return string $endkundeAdresse
     */
    public function getEndkundeAdresse()
    {
        return $this->endkundeAdresse;
    }

    /**
     * Sets the endkundeAdresse
     *
     * @param string $endkundeAdresse
     * @return void
     */
    public function setEndkundeAdresse($endkundeAdresse)
    {
        $this->endkundeAdresse = $endkundeAdresse;
    }

    /**
     * __construct
     */
    public function __construct()
    {
        //Do not remove the next line: It would break the functionality
        $this->initStorageObjects();
    }

    /**
     * Initializes all ObjectStorage properties
     * Do not modify this method!
     * It will be rewritten on each save in the extension builder
     * You may modify the constructor of this class instead
     *
     * @return void
     */
    protected function initStorageObjects()
    {
        $this->upload = new \TYPO3\CMS\Extbase\Persistence\ObjectStorage();
    }

    /**
     * Returns the reklamationLogistik
     *
     * @return bool $reklamationLogistik
     */
    public function getReklamationLogistik()
    {
        return $this->reklamationLogistik;
    }

    /**
     * Sets the reklamationLogistik
     *
     * @param bool $reklamationLogistik
     * @return void
     */
    public function setReklamationLogistik($reklamationLogistik)
    {
        $this->reklamationLogistik = $reklamationLogistik;
    }

    /**
     * Returns the boolean state of reklamationLogistik
     *
     * @return bool
     */
    public function isReklamationLogistik()
    {
        return $this->reklamationLogistik;
    }

    /**
     * Returns the logistikBeschreibung
     *
     * @return string $logistikBeschreibung
     */
    public function getLogistikBeschreibung()
    {
        return $this->logistikBeschreibung;
    }

    /**
     * Sets the logistikBeschreibung
     *
     * @param string $logistikBeschreibung
     * @return void
     */
    public function setLogistikBeschreibung($logistikBeschreibung)
    {
        $this->logistikBeschreibung = $logistikBeschreibung;
    }

    /**
     * Returns the reklamationTechnisch
     *
     * @return bool $reklamationTechnisch
     */
    public function getReklamationTechnisch()
    {
        return $this->reklamationTechnisch;
    }

    /**
     * Sets the reklamationTechnisch
     *
     * @param bool $reklamationTechnisch
     * @return void
     */
    public function setReklamationTechnisch($reklamationTechnisch)
    {
        $this->reklamationTechnisch = $reklamationTechnisch;
    }

    /**
     * Returns the boolean state of reklamationTechnisch
     *
     * @return bool
     */
    public function isReklamationTechnisch()
    {
        return $this->reklamationTechnisch;
    }

    /**
     * Returns the logistik
     *
     * @return array logistik
     */
    public function getLogistik()
    {
        //return unserialize($this->logistik); //save as array
        return explode(';', $this->logistik);
    }

    /**
     * Sets the logistik
     *
     * @param array $logistik
     * @return void
     */
    public function setLogistik(array $logistik)
    {
        //$this->logistik = serialize($logistik); //save as array
        $this->logistik = implode(';', $logistik);
    }

    /**
     * Returns the reklamationKundenservice
     *
     * @return bool $reklamationKundenservice
     */
    public function getReklamationKundenservice()
    {
        return $this->reklamationKundenservice;
    }

    /**
     * Sets the reklamationKundenservice
     *
     * @param bool $reklamationKundenservice
     * @return void
     */
    public function setReklamationKundenservice($reklamationKundenservice)
    {
        $this->reklamationKundenservice = $reklamationKundenservice;
    }

    /**
     * Returns the boolean state of reklamationKundenservice
     *
     * @return bool
     */
    public function isReklamationKundenservice()
    {
        return $this->reklamationKundenservice;
    }

    /**
     * Returns the kundenservice
     *
     * @return array $kundenservice
     */
    public function getKundenservice()
    {
        //return unserialize($this->kundenservice); //save as array
        return explode(';', $this->kundenservice);
    }

    /**
     * Sets the kundenservice
     *
     * @param sarray $kundenservice
     * @return void
     */
    public function setKundenservice(array $kundenservice)
    {
        //$this->kundenservice = serialize($kundenservice); //save as array
        $this->kundenservice = implode(';', $kundenservice);
    }

    /**
     * Returns the kundenserviceBeschreibung
     *
     * @return string $kundenserviceBeschreibung
     */
    public function getKundenserviceBeschreibung()
    {
        return $this->kundenserviceBeschreibung;
    }

    /**
     * Sets the kundenserviceBeschreibung
     *
     * @param string $kundenserviceBeschreibung
     * @return void
     */
    public function setKundenserviceBeschreibung($kundenserviceBeschreibung)
    {
        $this->kundenserviceBeschreibung = $kundenserviceBeschreibung;
    }

    /**
     * Returns the massnahmen
     *
     * @return array $massnahmen
     */
    public function getMassnahmen()
    {
        //return unserialize($this->massnahmen); //save as array
        return explode(';', $this->massnahmen);
    }

    /**
     * Sets the massnahmen
     *
     * @param array $massnahmen
     * @return void
     */
    public function setMassnahmen(array $massnahmen)
    {
        //$this->massnahmen = serialize($massnahmen); //save as array
        $this->massnahmen = implode(';', $massnahmen);
    }

    /**
     * Returns the fehlerort
     *
     * @return array $fehlerort
     */
    public function getFehlerort()
    {
        //return unserialize($this->fehlerort); //save as array
        return explode(';', $this->fehlerort);
    }

    /**
     * Sets the fehlerort
     *
     * @param array $fehlerort
     * @return void
     */
    public function setFehlerort(array $fehlerort)
    {
        //$this->fehlerort = serialize($fehlerort); //save as array
        $this->fehlerort = implode(';', $fehlerort);
    }

    /**
     * Returns the fehlermeldungSelect
     *
     * @return bool $fehlermeldungSelect
     */
    public function getFehlermeldungSelect()
    {
        return $this->fehlermeldungSelect;
    }

    /**
     * Sets the fehlermeldungSelect
     *
     * @param bool $fehlermeldungSelect
     * @return void
     */
    public function setFehlermeldungSelect($fehlermeldungSelect)
    {
        $this->fehlermeldungSelect = $fehlermeldungSelect;
    }

    /**
     * Returns the boolean state of fehlermeldungSelect
     *
     * @return bool
     */
    public function isFehlermeldungSelect()
    {
        return $this->fehlermeldungSelect;
    }

    /**
     * Returns the fehlermeldungCode
     *
     * @return string $fehlermeldungCode
     */
    public function getFehlermeldungCode()
    {
        return $this->fehlermeldungCode;
    }

    /**
     * Sets the fehlermeldungCode
     *
     * @param string $fehlermeldungCode
     * @return void
     */
    public function setFehlermeldungCode($fehlermeldungCode)
    {
        $this->fehlermeldungCode = $fehlermeldungCode;
    }

    /**
     * Returns the boolean state of programmSelect
     *
     * @return bool
     */
    public function isProgrammSelect()
    {
        return $this->programmSelect;
    }

    /**
     * Returns the boolean state of personenschadenSelect
     *
     * @return bool
     */
    public function isPersonenschadenSelect()
    {
        return $this->personenschadenSelect;
    }

    /**
     * Returns the personenschaden
     *
     * @return array $personenschaden
     */
    public function getPersonenschaden()
    {
        //return unserialize($this->personenschaden); //save as array
        return explode(';', $this->personenschaden);
    }

    /**
     * Sets the personenschaden
     *
     * @param array $personenschaden
     * @return void
     */
    public function setPersonenschaden($personenschaden)
    {
        //$this->personenschaden = serialize($personenschaden); //save as array
        $this->personenschaden = implode(';', $personenschaden);
    }

    /**
     * Returns the personenschadenBeschreibung
     *
     * @return string $personenschadenBeschreibung
     */
    public function getPersonenschadenBeschreibung()
    {
        return $this->personenschadenBeschreibung;
    }

    /**
     * Sets the personenschadenBeschreibung
     *
     * @param string $personenschadenBeschreibung
     * @return void
     */
    public function setPersonenschadenBeschreibung($personenschadenBeschreibung)
    {
        $this->personenschadenBeschreibung = $personenschadenBeschreibung;
    }

    /**
     * Returns the crashSelect
     *
     * @return bool $crashSelect
     */
    public function getCrashSelect()
    {
        return $this->crashSelect;
    }

    /**
     * Sets the crashSelect
     *
     * @param bool $crashSelect
     * @return void
     */
    public function setCrashSelect($crashSelect)
    {
        $this->crashSelect = $crashSelect;
    }

    /**
     * Returns the boolean state of crashSelect
     *
     * @return bool
     */
    public function isCrashSelect()
    {
        return $this->crashSelect;
    }

    /**
     * Returns the crash
     *
     * @return array $crash
     */
    public function getCrash()
    {
        //return unserialize($this->crash); //save as array
        return explode(';', $this->crash);
    }

    /**
     * Sets the crash
     *
     * @param array $crash
     * @return void
     */
    public function setCrash($crash)
    {
        //$this->crash = serialize($crash); //save as array
        $this->crash = implode(';', $crash);
    }

    /**
     * Returns the crashBeschreibung
     *
     * @return string $crashBeschreibung
     */
    public function getCrashBeschreibung()
    {
        return $this->crashBeschreibung;
    }

    /**
     * Sets the crashBeschreibung
     *
     * @param string $crashBeschreibung
     * @return void
     */
    public function setCrashBeschreibung($crashBeschreibung)
    {
        $this->crashBeschreibung = $crashBeschreibung;
    }

    /**
     * Returns the kurzschlussSelect
     *
     * @return bool $kurzschlussSelect
     */
    public function getKurzschlussSelect()
    {
        return $this->kurzschlussSelect;
    }

    /**
     * Sets the kurzschlussSelect
     *
     * @param bool $kurzschlussSelect
     * @return void
     */
    public function setKurzschlussSelect($kurzschlussSelect)
    {
        $this->kurzschlussSelect = $kurzschlussSelect;
    }

    /**
     * Returns the boolean state of kurzschlussSelect
     *
     * @return bool
     */
    public function isKurzschlussSelect()
    {
        return $this->kurzschlussSelect;
    }

    /**
     * Returns the kurzschluss
     *
     * @return array $kurzschluss
     */
    public function getKurzschluss()
    {
        //return unserialize($this->kurzschluss); //save as array
        return explode(';', $this->kurzschluss);
    }

    /**
     * Sets the kurzschluss
     *
     * @param array $kurzschluss
     * @return void
     */
    public function setKurzschluss($kurzschluss)
    {
        //$this->kurzschluss = serialize($kurzschluss); //save as array
        $this->kurzschluss = implode(';', $kurzschluss);
    }

    /**
     * Returns the kurzschlussBeschreibung
     *
     * @return array $kurzschlussBeschreibung
     */
    public function getKurzschlussBeschreibung()
    {
        return $this->kurzschlussBeschreibung;
    }

    /**
     * Sets the kurzschlussBeschreibung
     *
     * @param string $kurzschlussBeschreibung
     * @return void
     */
    public function setKurzschlussBeschreibung($kurzschlussBeschreibung)
    {
        $this->kurzschlussBeschreibung = $kurzschlussBeschreibung;
    }

    /**
     * Returns the fehlerBeschreibung
     *
     * @return string fehlerBeschreibung
     */
    public function getFehlerBeschreibung()
    {
        return $this->fehlerBeschreibung;
    }

    /**
     * Sets the fehlerBeschreibung
     *
     * @param string $fehlerBeschreibung
     * @return void
     */
    public function setFehlerBeschreibung($fehlerBeschreibung)
    {
        $this->fehlerBeschreibung = $fehlerBeschreibung;
    }

    /**
     * Returns the personenschadenSelect
     *
     * @return bool personenschadenSelect
     */
    public function getPersonenschadenSelect()
    {
        return $this->personenschadenSelect;
    }

    /**
     * Sets the personenschadenSelect
     *
     * @param bool $personenschadenSelect
     * @return void
     */
    public function setPersonenschadenSelect($personenschadenSelect)
    {
        $this->personenschadenSelect = $personenschadenSelect;
    }

    /**
     * Returns the produkt
     *
     * @return string $produkt
     */
    public function getProdukt()
    {
        return $this->produkt;
    }

    /**
     * Sets the produkt
     *
     * @param string $produkt
     * @return void
     */
    public function setProdukt($produkt)
    {
        $this->produkt = $produkt;
    }

    /**
     * Returns the zubehoer
     *
     * @return string $zubehoer
     */
    public function getZubehoer()
    {
        return $this->zubehoer;
    }

    /**
     * Sets the zubehoer
     *
     * @param string $zubehoer
     * @return void
     */
    public function setZubehoer($zubehoer)
    {
        $this->zubehoer = $zubehoer;
    }

    /**
     * Returns the defektekomponente
     *
     * @return string $defektekomponente
     */
    public function getDefektekomponente()
    {
        return $this->defektekomponente;
    }

    /**
     * Sets the defektekomponente
     * Sets the defektekomponente
     *
     * @param string $defektekomponente
     * @return void
     */
    public function setDefektekomponente($defektekomponente)
    {
        $this->defektekomponente = $defektekomponente;
    }

    /**
     * Adds a Upload
     *
     * @param \TYPO3\CMS\Extbase\Domain\Model\FileReference $uploadFile
     * @return void
     */
    public function addUpload(\TYPO3\CMS\Extbase\Domain\Model\FileReference $upload)
    {
        $this->upload->attach($upload);
    }

    /**
     * Removes a Upload
     *
     * @param \TYPO3\CMS\Extbase\Domain\Model\FileReference $uploadToRemove The Upload to be removed
     * @return void
     */
    public function removeUpload(\TYPO3\CMS\Extbase\Domain\Model\FileReference $uploadToRemove)
    {
        $this->upload->detach($uploadToRemove);
    }

    /**
     * Returns the upload
     *
     * @return \TYPO3\CMS\Extbase\Persistence\ObjectStorage<\TYPO3\CMS\Extbase\Domain\Model\FileReference> $upload
     */
    public function getUpload()
    {
        return $this->upload;
    }

    /**
     * Sets the upload
     *
     * @param \TYPO3\CMS\Extbase\Persistence\ObjectStorage<\TYPO3\CMS\Extbase\Domain\Model\FileReference> $upload
     * @return void
     */
    public function setUpload(\TYPO3\CMS\Extbase\Domain\Model\FileReference $upload)
    {
        $this->upload = $upload;
    }

    /**
     * Returns the defektekomponenteSelect
     *
     * @return bool $defektekomponenteSelect
     */
    public function getDefektekomponenteSelect()
    {
        return $this->defektekomponenteSelect;
    }

    /**
     * Sets the defektekomponenteSelect
     *
     * @param bool $defektekomponenteSelect
     * @return void
     */
    public function setDefektekomponenteSelect($defektekomponenteSelect)
    {
        $this->defektekomponenteSelect = $defektekomponenteSelect;
    }

    /**
     * Returns the boolean state of defektekomponenteSelect
     *
     * @return bool
     */
    public function isDefektekomponenteSelect()
    {
        return $this->defektekomponenteSelect;
    }

    /**
     * Returns the zubehoerBenutztinprodukt
     *
     * @return string zubehoerBenutztinprodukt
     */
    public function getZubehoerBenutztinprodukt()
    {
        return $this->zubehoerBenutztinprodukt;
    }

    /**
     * Sets the zubehoerBenutztinprodukt
     *
     * @param string $zubehoerBenutztinprodukt
     * @return void
     */
    public function setZubehoerBenutztinprodukt($zubehoerBenutztinprodukt)
    {
        $this->zubehoerBenutztinprodukt = $zubehoerBenutztinprodukt;
    }

    /**
     * Returns the ersatzteil
     *
     * @return string $ersatzteil
     */
    public function getErsatzteil()
    {
        return $this->ersatzteil;
    }

    /**
     * Sets the ersatzteil
     *
     * @param string $ersatzteil
     * @return void
     */
    public function setErsatzteil($ersatzteil)
    {
        $this->ersatzteil = $ersatzteil;
    }

    /**
     * Returns the ersatzteilBenutztinprodukt
     *
     * @return string $ersatzteilBenutztinprodukt
     */
    public function getErsatzteilBenutztinprodukt()
    {
        return $this->ersatzteilBenutztinprodukt;
    }

    /**
     * Sets the ersatzteilBenutztinprodukt
     *
     * @param string $ersatzteilBenutztinprodukt
     * @return void
     */
    public function setErsatzteilBenutztinprodukt($ersatzteilBenutztinprodukt)
    {
        $this->ersatzteilBenutztinprodukt = $ersatzteilBenutztinprodukt;
    }

    /**
     * Returns the erfasserSelect
     *
     * @return string $erfasserSelect
     */
    public function getErfasserSelect()
    {
        return $this->erfasserSelect;
    }

    /**
     * Sets the erfasserSelect
     *
     * @param string $erfasserSelect
     * @return void
     */
    public function setErfasserSelect($erfasserSelect)
    {
        $this->erfasserSelect = $erfasserSelect;
    }

    /**
     * Returns the fehlermeldungZeitpunkt
     *
     * @return \DateTime fehlermeldungZeitpunkt
     */
    public function getFehlermeldungZeitpunkt()
    {
        return $this->fehlermeldungZeitpunkt;
    }

    /**
     * Sets the fehlermeldungZeitpunkt
     *
     * @param string $fehlermeldungZeitpunkt
     * @return void
     */
    public function setFehlermeldungZeitpunkt($fehlermeldungZeitpunkt)
    {
        $this->fehlermeldungZeitpunkt = $fehlermeldungZeitpunkt;
    }

    /**
     * Returns the programmZentrifugeRpm
     *
     * @return string programmZentrifugeRpm
     */
    public function getProgrammZentrifugeRpm()
    {
        return $this->programmZentrifugeRpm;
    }

    /**
     * Sets the programmZentrifugeRpm
     *
     * @param string $programmZentrifugeRpm
     * @return void
     */
    public function setProgrammZentrifugeRpm($programmZentrifugeRpm)
    {
        $this->programmZentrifugeRpm = $programmZentrifugeRpm;
    }

    /**
     * Returns the programmZentrifugeRcf
     *
     * @return string programmZentrifugeRcf
     */
    public function getProgrammZentrifugeRcf()
    {
        return $this->programmZentrifugeRcf;
    }

    /**
     * Sets the programmZentrifugeRcf
     *
     * @param string $programmZentrifugeRcf
     * @return void
     */
    public function setProgrammZentrifugeRcf($programmZentrifugeRcf)
    {
        $this->programmZentrifugeRcf = $programmZentrifugeRcf;
    }

    /**
     * Returns the programmZentrifugeLaufzeit
     *
     * @return string programmZentrifugeLaufzeit
     */
    public function getProgrammZentrifugeLaufzeit()
    {
        return $this->programmZentrifugeLaufzeit;
    }

    /**
     * Sets the programmZentrifugeLaufzeit
     *
     * @param string $programmZentrifugeLaufzeit
     * @return void
     */
    public function setProgrammZentrifugeLaufzeit($programmZentrifugeLaufzeit)
    {
        $this->programmZentrifugeLaufzeit = $programmZentrifugeLaufzeit;
    }

    /**
     * Returns the programmZentrifugeTemp
     *
     * @return string programmZentrifugeTemp
     */
    public function getProgrammZentrifugeTemp()
    {
        return $this->programmZentrifugeTemp;
    }

    /**
     * Sets the programmZentrifugeTemp
     *
     * @param string $programmZentrifugeTemp
     * @return void
     */
    public function setProgrammZentrifugeTemp($programmZentrifugeTemp)
    {
        $this->programmZentrifugeTemp = $programmZentrifugeTemp;
    }

    /**
     * Returns the programmZentrifugeAnlauf
     *
     * @return string programmZentrifugeAnlauf
     */
    public function getProgrammZentrifugeAnlauf()
    {
        return $this->programmZentrifugeAnlauf;
    }

    /**
     * Sets the programmZentrifugeAnlauf
     *
     * @param string $programmZentrifugeAnlauf
     * @return void
     */
    public function setProgrammZentrifugeAnlauf($programmZentrifugeAnlauf)
    {
        $this->programmZentrifugeAnlauf = $programmZentrifugeAnlauf;
    }

    /**
     * Returns the programmZentrifugeAuslauf
     *
     * @return string programmZentrifugeAuslauf
     */
    public function getProgrammZentrifugeAuslauf()
    {
        return $this->programmZentrifugeAuslauf;
    }

    /**
     * Sets the programmZentrifugeAuslauf
     *
     * @param string $programmZentrifugeAuslauf
     * @return void
     */
    public function setProgrammZentrifugeAuslauf($programmZentrifugeAuslauf)
    {
        $this->programmZentrifugeAuslauf = $programmZentrifugeAuslauf;
    }

    /**
     * Returns the programmInkubatorBruttemperatur
     *
     * @return string $programmInkubatorBruttemperatur
     */
    public function getProgrammInkubatorBruttemperatur()
    {
        return $this->programmInkubatorBruttemperatur;
    }

    /**
     * Sets the programmInkubatorBruttemperatur
     *
     * @param string $programmInkubatorBruttemperatur
     * @return void
     */
    public function setProgrammInkubatorBruttemperatur($programmInkubatorBruttemperatur)
    {
        $this->programmInkubatorBruttemperatur = $programmInkubatorBruttemperatur;
    }

    /**
     * Returns the programmInkubatorStartendpunkt
     *
     * @return string $programmInkubatorStartendpunkt
     */
    public function getProgrammInkubatorStartendpunkt()
    {
        return $this->programmInkubatorStartendpunkt;
    }

    /**
     * Sets the programmInkubatorStartendpunkt
     *
     * @param string $programmInkubatorStartendpunkt
     * @return void
     */
    public function setProgrammInkubatorStartendpunkt($programmInkubatorStartendpunkt)
    {
        $this->programmInkubatorStartendpunkt = $programmInkubatorStartendpunkt;
    }

    /**
     * Returns the programmInkubatorBrutzeit
     *
     * @return string $programmInkubatorBrutzeit
     */
    public function getProgrammInkubatorBrutzeit()
    {
        return $this->programmInkubatorBrutzeit;
    }

    /**
     * Sets the programmInkubatorBrutzeit
     *
     * @param string $programmInkubatorBrutzeit
     * @return void
     */
    public function setProgrammInkubatorBrutzeit($programmInkubatorBrutzeit)
    {
        $this->programmInkubatorBrutzeit = $programmInkubatorBrutzeit;
    }

    /**
     * Returns the programmInkubatorAbsenktemperatur
     *
     * @return string $programmInkubatorAbsenktemperatur
     */
    public function getProgrammInkubatorAbsenktemperatur()
    {
        return $this->programmInkubatorAbsenktemperatur;
    }

    /**
     * Sets the programmInkubatorAbsenktemperatur
     *
     * @param string $programmInkubatorAbsenktemperatur
     * @return void
     */
    public function setProgrammInkubatorAbsenktemperatur($programmInkubatorAbsenktemperatur)
    {
        $this->programmInkubatorAbsenktemperatur = $programmInkubatorAbsenktemperatur;
    }

    /**
     * Returns the programmInkubatorExternerkontakt
     *
     * @return string $programmInkubatorExternerkontakt
     */
    public function getProgrammInkubatorExternerkontakt()
    {
        return $this->programmInkubatorExternerkontakt;
    }

    /**
     * Sets the programmInkubatorExternerkontakt
     *
     * @param string $programmInkubatorExternerkontakt
     * @return void
     */
    public function setProgrammInkubatorExternerkontakt($programmInkubatorExternerkontakt)
    {
        $this->programmInkubatorExternerkontakt = $programmInkubatorExternerkontakt;
    }

    /**
     * Returns the programmInkubatorSegmentnummer
     *
     * @return string $programmInkubatorSegmentnummer
     */
    public function getProgrammInkubatorSegmentnummer()
    {
        return $this->programmInkubatorSegmentnummer;
    }

    /**
     * Sets the programmInkubatorSegmentnummer
     *
     * @param string $programmInkubatorSegmentnummer
     * @return void
     */
    public function setProgrammInkubatorSegmentnummer($programmInkubatorSegmentnummer)
    {
        $this->programmInkubatorSegmentnummer = $programmInkubatorSegmentnummer;
    }

    /**
     * Returns the programmSelect
     *
     * @return bool programmSelect
     */
    public function getProgrammSelect()
    {
        return $this->programmSelect;
    }

    /**
     * Sets the programmSelect
     *
     * @param bool $programmSelect
     * @return void
     */
    public function setProgrammSelect($programmSelect)
    {
        $this->programmSelect = $programmSelect;
    }
}
