<?php
namespace TEUFELS\Htc19ExtNonconformityreport\Domain\Repository;

/***
 *
 * This file is part of the "htc19_ext_nonconformityreport" Extension for TYPO3 CMS.
 *
 * For the full copyright and license information, please read the
 * LICENSE.txt file that was distributed with this source code.
 *
 *  (c) 2019 Bastian Holzem <b.holzem@teufels.com>, teufels GmbH
 *
 ***/

/**
 * The repository for Massnahmen
 */
class MassnahmenRepository extends \KITT3N\Kitt3nUserfuncs\Domain\Repository\AbstractRepository
{

    public function initializeObject()
    {
        $sUserFuncModel = 'TEUFELS\\Htc19ExtNonconformityreport\\Domain\\Model\\Massnahmen';
        $sUserFuncPlugin = 'htc19_ext_nonconformityreport';
        parent::overrideQuerySettings($sUserFuncModel, $sUserFuncPlugin);
    }

    /**
     * Returns all objects of this repository.
     *
     * @return Massnahmen|array
     * @api
     */
    public function findAll()
    {
        $query = $this->createQuery();
        $query->getQuerySettings()->setRespectSysLanguage(TRUE);
        $query->getQuerySettings()->setRespectStoragePage(FALSE);
        return $query->execute();
    }

    protected $defaultOrderings = array(
        'sorting' => \TYPO3\CMS\Extbase\Persistence\QueryInterface::ORDER_ASCENDING,
        // ::ORDER_DESCENDING = Absteigende Sortierung
    );
}