<?php
namespace TEUFELS\Htc19ExtNonconformityreport\Domain\Repository;

/***
 *
 * This file is part of the "htc19_ext_nonconformityreport" Extension for TYPO3 CMS.
 *
 * For the full copyright and license information, please read the
 * LICENSE.txt file that was distributed with this source code.
 *
 *  (c) 2019 Bastian Holzem <b.holzem@teufels.com>, teufels GmbH
 *
 ***/

/**
 * The repository for Produktkategorie
 */
class ProduktkategorieRepository extends \KITT3N\Kitt3nUserfuncs\Domain\Repository\AbstractRepository
{

    public function initializeObject()
    {
        $sUserFuncModel = 'TEUFELS\\Htc19ExtNonconformityreport\\Domain\\Model\\Produktkategorie';
        $sUserFuncPlugin = 'htc19_ext_nonconformityreport';
        parent::overrideQuerySettings($sUserFuncModel, $sUserFuncPlugin);
    }

    /**
     * Returns all objects of this repository.
     *
     * @return Produktkategorie|array
     * @api
     */
    public function findAll()
    {
        $query = $this->createQuery();
        $query->getQuerySettings()->setRespectSysLanguage(TRUE);
        $query->getQuerySettings()->setRespectStoragePage(FALSE);
        return $query->execute();
    }

    /**
     * @param $iUid
     * @return array|\TYPO3\CMS\Extbase\Persistence\QueryResultInterface
     */
    public function findByUid($iUid)
    {
        $query = $this->createQuery();
        $query->getQuerySettings()->setRespectSysLanguage(TRUE);
        $query->matching($query->in('uid', [$iUid]));
        return $query->execute();
    }

    /**
     * @param $iUid
     * @return array|\TYPO3\CMS\Extbase\Persistence\QueryResultInterface
     */
    public function findByAllExcludeUid($iUid)
    {
        $query = $this->createQuery();
        $query->getQuerySettings()->setRespectSysLanguage(TRUE);

        $query->matching(
            $query->logicalAnd(
                [
                    $query->logicalNot(
                        $query->in('uid', [$iUid])
                    ),
                    $query->logicalNot(
                        $query->in('l10n_parent', [$iUid])
                    )
                ]
            )
        );

        return $query->execute();
    }



    protected $defaultOrderings = array(
        'sorting' => \TYPO3\CMS\Extbase\Persistence\QueryInterface::ORDER_ASCENDING,
        // ::ORDER_DESCENDING = Absteigende Sortierung
    );
}