<?php
namespace TEUFELS\Htc19ExtNonconformityreport\Domain\Repository;

/***
 *
 * This file is part of the "htc19_ext_nonconformityreport" Extension for TYPO3 CMS.
 *
 * For the full copyright and license information, please read the
 * LICENSE.txt file that was distributed with this source code.
 *
 *  (c) 2019 Bastian Holzem <b.holzem@teufels.com>, teufels GmbH
 *
 ***/

/**
 * The repository for Report
 */
class ReportRepository extends \KITT3N\Kitt3nUserfuncs\Domain\Repository\AbstractRepository
{
    public function initializeObject()
    {
        $sUserFuncModel = 'TEUFELS\\Htc19ExtNonconformityreport\\Domain\\Model\\Report';
        $sUserFuncPlugin = 'htc19_ext_nonconformityreport';
        parent::overrideQuerySettings($sUserFuncModel, $sUserFuncPlugin);
    }

    /**
    * Find last Report
    *
    * @return Report
    */
    public function findLastReport()
    {
        $query = $this->createQuery();
        $query->getQuerySettings()->setRespectSysLanguage(TRUE);
        $query->getQuerySettings()->setRespectStoragePage(FALSE);

        $query->setOrderings(
            [
                'uid' => \TYPO3\CMS\Extbase\Persistence\QueryInterface::ORDER_DESCENDING
            ]
        );

        return $query->execute()->getFirst();
    }

}