<?php
namespace TEUFELS\Htc19ExtNonconformityreport\ViewHelpers\Format;

/**
 * The MIT License (MIT)
 *
 * Copyright (c) 2018 Oliver Merz, Georg Kathan, Dominik Hilser - kitt3n.de
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 * copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in
 * all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
 * THE SOFTWARE.
 *
 **/

use TYPO3\CMS\Core\Utility\GeneralUtility;
use TYPO3Fluid\Fluid\Core\ViewHelper\AbstractViewHelper;

/**
 * Prepares text for use in JavaScript: removes line breaks
 */
class GetTranslationKeyFromPropertyPathViewHelper extends AbstractViewHelper {

    /**
     * initialize arguments
     *
     * String :: text
     *
     */
    public function initializeArguments()
    {
        $this->registerArgument('text', 'string', 'Text in which the linebreaks should be replaced', true);
    }

    /**
     *
     * @return string
     *
     * Use e.g.:
     * <html xmlns:htc="http://typo3.org/ns/TEUFELS/Htc19ExtNonconformityreport/ViewHelpers">
     * or
     * {namespace htc=TEUFELS\Htc19ExtNonconformityreport\ViewHelpers}
     * ...
     * <htc:format.getTranslationKeyFromPropertyPath text="Zeile1 \n Zeile2 \n Zeile 3"/>
     * ...
     */
    public function render()
    {
        if(!$this->arguments['text']) {
            $this->arguments['text'] = $this->renderChildren();
        }

        $aReplaceWith = ['tx_htc19extnonconformityreport_domain_model_report', ''];
        $aReplace = ['newReport', 'Select'];

        $text = str_replace($aReplace, $aReplaceWith, $this->arguments['text']);
        $text = ltrim(strtolower(preg_replace('/[A-Z]([A-Z](?![a-z]))*/', '_$0', $text)), '_');

        switch (true) {
            case strpos($text, '.erfasser_select') !== false:
            case strpos($text, '.endkunde') !== false:
                $text = 'LLL:EXT:htc19_ext_nonconformityreport/Resources/Private/Language/translation.erfasserdaten.xlf:' . $text;
                break;
            case strpos($text, '.produkt') !== false:
            case strpos($text, '.defektekomponente') !== false:
            case strpos($text, '.zubehoer') !== false:
            case strpos($text, '.ersatzteil') !== false:
            case strpos($text, '.fehler') !== false:
            case strpos($text, '.programm') !== false:
            case strpos($text, '.personenschaden') !== false:
            case strpos($text, '.kurzschluss') !== false:
            case strpos($text, '.crash') !== false:
                $text = 'LLL:EXT:htc19_ext_nonconformityreport/Resources/Private/Language/translation.reklamation_technisch.xlf:' . $text;
                break;
            default:
                $text = 'LLL:EXT:htc19_ext_nonconformityreport/Resources/Private/Language/translation.xlf:' . $text;
        }


        return $text;
    }

}