<?php
return [
    'ctrl' => [
        'title' => 'LLL:EXT:htc19_ext_nonconformityreport/Resources/Private/Language/locallang_db.xlf:tx_htc19extnonconformityreport_domain_model_produktgruppe',
        'label' => 'backendtitle',
        'tstamp' => 'tstamp',
        'crdate' => 'crdate',
        'cruser_id' => 'cruser_id',
        'versioningWS' => true,
        'languageField' => 'sys_language_uid',
        'transOrigPointerField' => 'l10n_parent',
        'transOrigDiffSourceField' => 'l10n_diffsource',
        'delete' => 'deleted',
        'enablecolumns' => [
            'disabled' => 'hidden',
            'starttime' => 'starttime',
            'endtime' => 'endtime',
        ],
        'searchFields' => 'backendtitle,title,identifier,sorting,produktkategorie',
        'iconfile' => 'EXT:htc19_ext_nonconformityreport/Resources/Public/Icons/tx_htc19extnonconformityreport_domain_model_produktgruppe.gif'
    ],
    'interface' => [
        'showRecordFieldList' => 'sys_language_uid, l10n_parent, l10n_diffsource, hidden, backendtitle, title, identifier, sorting, produktkategorie',
    ],
    'types' => [
        '1' => ['showitem' => 'sys_language_uid, l10n_parent, l10n_diffsource, hidden, backendtitle, title, identifier, sorting, produktkategorie, --div--;LLL:EXT:frontend/Resources/Private/Language/locallang_ttc.xlf:tabs.access, starttime, endtime'],
    ],
    'columns' => [
        'sys_language_uid' => [
            'exclude' => true,
            'label' => 'LLL:EXT:lang/locallang_general.xlf:LGL.language',
            'config' => [
                'type' => 'select',
                'renderType' => 'selectSingle',
                'special' => 'languages',
                'items' => [
                    [
                        'LLL:EXT:lang/locallang_general.xlf:LGL.allLanguages',
                        -1,
                        'flags-multiple'
                    ]
                ],
                'default' => 0,
            ],
        ],
        'l10n_parent' => [
            'displayCond' => 'FIELD:sys_language_uid:>:0',
            'exclude' => true,
            'label' => 'LLL:EXT:lang/locallang_general.xlf:LGL.l18n_parent',
            'config' => [
                'type' => 'select',
                'renderType' => 'selectSingle',
                'items' => [
                    ['', 0],
                ],
                'foreign_table' => 'tx_htc19extnonconformityreport_domain_model_produktgruppe',
                'foreign_table_where' => 'AND tx_htc19extnonconformityreport_domain_model_produktgruppe.pid=###CURRENT_PID### AND tx_htc19extnonconformityreport_domain_model_produktgruppe.sys_language_uid IN (-1,0)',
            ],
        ],
        'l10n_diffsource' => [
            'config' => [
                'type' => 'passthrough',
            ],
        ],
        't3ver_label' => [
            'label' => 'LLL:EXT:lang/locallang_general.xlf:LGL.versionLabel',
            'config' => [
                'type' => 'input',
                'size' => 30,
                'max' => 255,
            ],
        ],
        'hidden' => [
            'exclude' => true,
            'label' => 'LLL:EXT:lang/locallang_general.xlf:LGL.hidden',
            'config' => [
                'type' => 'check',
                'items' => [
                    '1' => [
                        '0' => 'LLL:EXT:lang/locallang_core.xlf:labels.enabled'
                    ]
                ],
            ],
        ],
        'starttime' => [
            'exclude' => true,
            'l10n_mode' => 'mergeIfNotBlank',
            'label' => 'LLL:EXT:lang/locallang_general.xlf:LGL.starttime',
            'config' => [
                'type' => 'input',
                'size' => 13,
                'eval' => 'datetime',
                'default' => 0,
            ],
        ],
        'endtime' => [
            'exclude' => true,
            'l10n_mode' => 'mergeIfNotBlank',
            'label' => 'LLL:EXT:lang/locallang_general.xlf:LGL.endtime',
            'config' => [
                'type' => 'input',
                'size' => 13,
                'eval' => 'datetime',
                'default' => 0,
                'range' => [
                    'upper' => mktime(0, 0, 0, 1, 1, 2038)
                ],
            ],
        ],

        'backendtitle' => [
            'exclude' => true,
            'label' => 'LLL:EXT:htc19_ext_nonconformityreport/Resources/Private/Language/locallang_db.xlf:tx_htc19extnonconformityreport_domain_model_produktgruppe.backendtitle',
            'config' => [
                'type' => 'input',
                'size' => 30,
                'eval' => 'trim'
            ],
        ],
        'title' => [
            'exclude' => true,
            'label' => 'LLL:EXT:htc19_ext_nonconformityreport/Resources/Private/Language/locallang_db.xlf:tx_htc19extnonconformityreport_domain_model_produktgruppe.title',
            'config' => [
                'type' => 'input',
                'size' => 30,
                'eval' => 'trim'
            ],
        ],
        'identifier' => [
            'exclude' => true,
            'label' => 'LLL:EXT:htc19_ext_nonconformityreport/Resources/Private/Language/locallang_db.xlf:tx_htc19extnonconformityreport_domain_model_produktgruppe.identifier',
            'config' => [
                'type' => 'input',
                'size' => 30,
                'eval' => 'trim'
            ],
        ],
        'sorting' => [
            'exclude' => true,
            'label' => 'LLL:EXT:htc19_ext_nonconformityreport/Resources/Private/Language/locallang_db.xlf:tx_htc19extnonconformityreport_domain_model_produktgruppe.sorting',
            'config' => [
                'type' => 'input',
                'size' => 4,
                'eval' => 'int'
            ]
        ],
        'produktkategorie' => [
            'exclude' => true,
            'label' => 'LLL:EXT:htc19_ext_nonconformityreport/Resources/Private/Language/locallang_db.xlf:tx_htc19extnonconformityreport_domain_model_produktgruppe.produktkategorie',
            'config' => [
                'type' => 'select',
                'renderType' => 'selectSingle',
                'foreign_table' => 'tx_htc19extnonconformityreport_domain_model_produktkategorie',
                'minitems' => 0,
                'maxitems' => 1,
            ],
        ],
    
    ],
];
