![version 1.0.0](https://img.shields.io/badge/version-0.0.1-00b2b2.svg?style=flat-square)

# README #
Hettich Mängelbericht 
[htc19_ext_nonconformityreport]

- - -

## Beschreibung

Extension für Hettich Mängelbericht

Ein Benutzer kann nach Registrierung/Anmeldung über ein Formular einen Mängelbericht einreichen.
Diesem Bericht kann der Benutzer auch (bis zu 10) Dateien anhängen. 
Dem Bericht wird bei absenden eine Referenznummer zugewiesen und unter dieser Referenznummer 
wird ein Export des Berichtes als xml und die Dateianhänge als zip abgelegt. 

Der Benutzer kann sich nach absenden seinen Bericht als PDF drucken.


### Datastructure

###### Export
* <URL>/reports/<Referenznummer>/<Referenznummer>.xml
* <URL>/reports/<Referenznummer>/upload.zip


### Additional Extensions
* [sjbr/sr-feuser-register](https://extensions.typo3.org/extension/sr_feuser_register/) (FE User Regsiter)
* [beewilly/hive_ext_wkhtmltopdf](https://bitbucket.org/teufels/hive_ext_wkhtmltopdf/) (PDF Generierung)


### Changes on Extension
If you make changes (via Extension Builder)  you need to add changes to following again:
#####Classes/Controller/ReportController.php
add at end:
```php
class CustomDOMDocument extends \DOMDocument {

    function createElementWithText($name, $child_text) {

        /**
         * Creates an element with a child text node
         *
         * @param  string  $name        element tag name
         * @param  string  $child_text  child node text
         * @return  object  new element
         */

        $element = $this->createElement($name);

        $element_text = $this->createTextNode( nl2br($child_text) );
        $element->appendChild($element_text);

        return $element;
    }

    function createElementWithJSON($name, $child_json) {

        $element = $this->createElement($name);

        $object = json_decode($child_json);

        foreach ($object as $key => $value) {
            $element_object = $this->createElement($key, (string)$value);
            $element->appendChild($element_object);
        }

        return $element;

    }
}
```
#####Classes/Domain/Model/Report.php
Changes for `upload` => replace with existing:
```php
/**
 * upload
 *
 * @var \TYPO3\CMS\Extbase\Persistence\ObjectStorage<\TYPO3\CMS\Extbase\Domain\Model\FileReference>
 * @TYPO3\CMS\Extbase\Annotation\ORM\Cascade remove
 */
protected $upload = null;
```
```php
 /**
 * Initializes all ObjectStorage properties
 * Do not modify this method!
 * It will be rewritten on each save in the extension builder
 * You may modify the constructor of this class instead
 *
 * @return void
 */
protected function initStorageObjects()
{
    $this->upload = new \TYPO3\CMS\Extbase\Persistence\ObjectStorage();
}
```


### Typo3 v9 Update
Keep in mind that with Typo3 9.5 you have to change Extension Key to `htc_ext_nonconformityreport` 
as long as Numbers (`_19_`) in Extension Keys not working. 