<?php
namespace TEUFELS\Htc19ExtNonconformityreport\Tests\Unit\Controller;

/**
 * Test case.
 *
 * @author Bastian Holzem <b.holzem@teufels.com>
 */
class ReportControllerTest extends \TYPO3\CMS\Core\Tests\UnitTestCase
{
    /**
     * @var \TEUFELS\Htc19ExtNonconformityreport\Controller\ReportController
     */
    protected $subject = null;

    protected function setUp()
    {
        parent::setUp();
        $this->subject = $this->getMockBuilder(\TEUFELS\Htc19ExtNonconformityreport\Controller\ReportController::class)
            ->setMethods(['redirect', 'forward', 'addFlashMessage'])
            ->disableOriginalConstructor()
            ->getMock();
    }

    protected function tearDown()
    {
        parent::tearDown();
    }

    /**
     * @test
     */
    public function showActionAssignsTheGivenReportToView()
    {
        $report = new \TEUFELS\Htc19ExtNonconformityreport\Domain\Model\Report();

        $view = $this->getMockBuilder(\TYPO3\CMS\Extbase\Mvc\View\ViewInterface::class)->getMock();
        $this->inject($this->subject, 'view', $view);
        $view->expects(self::once())->method('assign')->with('report', $report);

        $this->subject->showAction($report);
    }

    /**
     * @test
     */
    public function createActionAddsTheGivenReportToReportRepository()
    {
        $report = new \TEUFELS\Htc19ExtNonconformityreport\Domain\Model\Report();

        $reportRepository = $this->getMockBuilder(\::class)
            ->setMethods(['add'])
            ->disableOriginalConstructor()
            ->getMock();

        $reportRepository->expects(self::once())->method('add')->with($report);
        $this->inject($this->subject, 'reportRepository', $reportRepository);

        $this->subject->createAction($report);
    }
}
