<?php
namespace TEUFELS\Htc19ExtNonconformityreport\Tests\Unit\Domain\Model;

/**
 * Test case.
 *
 * @author Bastian Holzem <b.holzem@teufels.com>
 */
class ReportTest extends \TYPO3\CMS\Core\Tests\UnitTestCase
{
    /**
     * @var \TEUFELS\Htc19ExtNonconformityreport\Domain\Model\Report
     */
    protected $subject = null;

    protected function setUp()
    {
        parent::setUp();
        $this->subject = new \TEUFELS\Htc19ExtNonconformityreport\Domain\Model\Report();
    }

    protected function tearDown()
    {
        parent::tearDown();
    }

    /**
     * @test
     */
    public function getReferenznummerReturnsInitialValueForInt()
    {
        self::assertSame(
            0,
            $this->subject->getReferenznummer()
        );
    }

    /**
     * @test
     */
    public function setReferenznummerForIntSetsReferenznummer()
    {
        $this->subject->setReferenznummer(12);

        self::assertAttributeEquals(
            12,
            'referenznummer',
            $this->subject
        );
    }

    /**
     * @test
     */
    public function getReklamationsdatumReturnsInitialValueForDateTime()
    {
        self::assertEquals(
            null,
            $this->subject->getReklamationsdatum()
        );
    }

    /**
     * @test
     */
    public function setReklamationsdatumForDateTimeSetsReklamationsdatum()
    {
        $dateTimeFixture = new \DateTime();
        $this->subject->setReklamationsdatum($dateTimeFixture);

        self::assertAttributeEquals(
            $dateTimeFixture,
            'reklamationsdatum',
            $this->subject
        );
    }

    /**
     * @test
     */
    public function getErfasserSelectReturnsInitialValueForString()
    {
        self::assertSame(
            '',
            $this->subject->getErfasserSelect()
        );
    }

    /**
     * @test
     */
    public function setErfasserSelectForStringSetsErfasserSelect()
    {
        $this->subject->setErfasserSelect('Conceived at T3CON10');

        self::assertAttributeEquals(
            'Conceived at T3CON10',
            'erfasserSelect',
            $this->subject
        );
    }

    /**
     * @test
     */
    public function getKundeNummerReturnsInitialValueForString()
    {
        self::assertSame(
            '',
            $this->subject->getKundeNummer()
        );
    }

    /**
     * @test
     */
    public function setKundeNummerForStringSetsKundeNummer()
    {
        $this->subject->setKundeNummer('Conceived at T3CON10');

        self::assertAttributeEquals(
            'Conceived at T3CON10',
            'kundeNummer',
            $this->subject
        );
    }

    /**
     * @test
     */
    public function getKundeNameReturnsInitialValueForString()
    {
        self::assertSame(
            '',
            $this->subject->getKundeName()
        );
    }

    /**
     * @test
     */
    public function setKundeNameForStringSetsKundeName()
    {
        $this->subject->setKundeName('Conceived at T3CON10');

        self::assertAttributeEquals(
            'Conceived at T3CON10',
            'kundeName',
            $this->subject
        );
    }

    /**
     * @test
     */
    public function getKundeTelefonReturnsInitialValueForString()
    {
        self::assertSame(
            '',
            $this->subject->getKundeTelefon()
        );
    }

    /**
     * @test
     */
    public function setKundeTelefonForStringSetsKundeTelefon()
    {
        $this->subject->setKundeTelefon('Conceived at T3CON10');

        self::assertAttributeEquals(
            'Conceived at T3CON10',
            'kundeTelefon',
            $this->subject
        );
    }

    /**
     * @test
     */
    public function getKundeEmailReturnsInitialValueForString()
    {
        self::assertSame(
            '',
            $this->subject->getKundeEmail()
        );
    }

    /**
     * @test
     */
    public function setKundeEmailForStringSetsKundeEmail()
    {
        $this->subject->setKundeEmail('Conceived at T3CON10');

        self::assertAttributeEquals(
            'Conceived at T3CON10',
            'kundeEmail',
            $this->subject
        );
    }

    /**
     * @test
     */
    public function getKundeAdresseReturnsInitialValueForString()
    {
        self::assertSame(
            '',
            $this->subject->getKundeAdresse()
        );
    }

    /**
     * @test
     */
    public function setKundeAdresseForStringSetsKundeAdresse()
    {
        $this->subject->setKundeAdresse('Conceived at T3CON10');

        self::assertAttributeEquals(
            'Conceived at T3CON10',
            'kundeAdresse',
            $this->subject
        );
    }

    /**
     * @test
     */
    public function getMeldenderNameReturnsInitialValueForString()
    {
        self::assertSame(
            '',
            $this->subject->getMeldenderName()
        );
    }

    /**
     * @test
     */
    public function setMeldenderNameForStringSetsMeldenderName()
    {
        $this->subject->setMeldenderName('Conceived at T3CON10');

        self::assertAttributeEquals(
            'Conceived at T3CON10',
            'meldenderName',
            $this->subject
        );
    }

    /**
     * @test
     */
    public function getMeldenderKontaktReturnsInitialValueForString()
    {
        self::assertSame(
            '',
            $this->subject->getMeldenderKontakt()
        );
    }

    /**
     * @test
     */
    public function setMeldenderKontaktForStringSetsMeldenderKontakt()
    {
        $this->subject->setMeldenderKontakt('Conceived at T3CON10');

        self::assertAttributeEquals(
            'Conceived at T3CON10',
            'meldenderKontakt',
            $this->subject
        );
    }

    /**
     * @test
     */
    public function getEndkundeAbweichendReturnsInitialValueForBool()
    {
        self::assertSame(
            false,
            $this->subject->getEndkundeAbweichend()
        );
    }

    /**
     * @test
     */
    public function setEndkundeAbweichendForBoolSetsEndkundeAbweichend()
    {
        $this->subject->setEndkundeAbweichend(true);

        self::assertAttributeEquals(
            true,
            'endkundeAbweichend',
            $this->subject
        );
    }

    /**
     * @test
     */
    public function getEndkundeNameReturnsInitialValueForString()
    {
        self::assertSame(
            '',
            $this->subject->getEndkundeName()
        );
    }

    /**
     * @test
     */
    public function setEndkundeNameForStringSetsEndkundeName()
    {
        $this->subject->setEndkundeName('Conceived at T3CON10');

        self::assertAttributeEquals(
            'Conceived at T3CON10',
            'endkundeName',
            $this->subject
        );
    }

    /**
     * @test
     */
    public function getEndkundeTelefonReturnsInitialValueForString()
    {
        self::assertSame(
            '',
            $this->subject->getEndkundeTelefon()
        );
    }

    /**
     * @test
     */
    public function setEndkundeTelefonForStringSetsEndkundeTelefon()
    {
        $this->subject->setEndkundeTelefon('Conceived at T3CON10');

        self::assertAttributeEquals(
            'Conceived at T3CON10',
            'endkundeTelefon',
            $this->subject
        );
    }

    /**
     * @test
     */
    public function getEndkundeEmailReturnsInitialValueForString()
    {
        self::assertSame(
            '',
            $this->subject->getEndkundeEmail()
        );
    }

    /**
     * @test
     */
    public function setEndkundeEmailForStringSetsEndkundeEmail()
    {
        $this->subject->setEndkundeEmail('Conceived at T3CON10');

        self::assertAttributeEquals(
            'Conceived at T3CON10',
            'endkundeEmail',
            $this->subject
        );
    }

    /**
     * @test
     */
    public function getEndkundeAdresseReturnsInitialValueForString()
    {
        self::assertSame(
            '',
            $this->subject->getEndkundeAdresse()
        );
    }

    /**
     * @test
     */
    public function setEndkundeAdresseForStringSetsEndkundeAdresse()
    {
        $this->subject->setEndkundeAdresse('Conceived at T3CON10');

        self::assertAttributeEquals(
            'Conceived at T3CON10',
            'endkundeAdresse',
            $this->subject
        );
    }

    /**
     * @test
     */
    public function getReklamationTechnischReturnsInitialValueForBool()
    {
        self::assertSame(
            false,
            $this->subject->getReklamationTechnisch()
        );
    }

    /**
     * @test
     */
    public function setReklamationTechnischForBoolSetsReklamationTechnisch()
    {
        $this->subject->setReklamationTechnisch(true);

        self::assertAttributeEquals(
            true,
            'reklamationTechnisch',
            $this->subject
        );
    }

    /**
     * @test
     */
    public function getProduktReturnsInitialValueForString()
    {
        self::assertSame(
            '',
            $this->subject->getProdukt()
        );
    }

    /**
     * @test
     */
    public function setProduktForStringSetsProdukt()
    {
        $this->subject->setProdukt('Conceived at T3CON10');

        self::assertAttributeEquals(
            'Conceived at T3CON10',
            'produkt',
            $this->subject
        );
    }

    /**
     * @test
     */
    public function getZubehoerReturnsInitialValueForString()
    {
        self::assertSame(
            '',
            $this->subject->getZubehoer()
        );
    }

    /**
     * @test
     */
    public function setZubehoerForStringSetsZubehoer()
    {
        $this->subject->setZubehoer('Conceived at T3CON10');

        self::assertAttributeEquals(
            'Conceived at T3CON10',
            'zubehoer',
            $this->subject
        );
    }

    /**
     * @test
     */
    public function getZubehoerBenutztinproduktReturnsInitialValueForString()
    {
        self::assertSame(
            '',
            $this->subject->getZubehoerBenutztinprodukt()
        );
    }

    /**
     * @test
     */
    public function setZubehoerBenutztinproduktForStringSetsZubehoerBenutztinprodukt()
    {
        $this->subject->setZubehoerBenutztinprodukt('Conceived at T3CON10');

        self::assertAttributeEquals(
            'Conceived at T3CON10',
            'zubehoerBenutztinprodukt',
            $this->subject
        );
    }

    /**
     * @test
     */
    public function getErsatzteilReturnsInitialValueForString()
    {
        self::assertSame(
            '',
            $this->subject->getErsatzteil()
        );
    }

    /**
     * @test
     */
    public function setErsatzteilForStringSetsErsatzteil()
    {
        $this->subject->setErsatzteil('Conceived at T3CON10');

        self::assertAttributeEquals(
            'Conceived at T3CON10',
            'ersatzteil',
            $this->subject
        );
    }

    /**
     * @test
     */
    public function getErsatzteilBenutztinproduktReturnsInitialValueForString()
    {
        self::assertSame(
            '',
            $this->subject->getErsatzteilBenutztinprodukt()
        );
    }

    /**
     * @test
     */
    public function setErsatzteilBenutztinproduktForStringSetsErsatzteilBenutztinprodukt()
    {
        $this->subject->setErsatzteilBenutztinprodukt('Conceived at T3CON10');

        self::assertAttributeEquals(
            'Conceived at T3CON10',
            'ersatzteilBenutztinprodukt',
            $this->subject
        );
    }

    /**
     * @test
     */
    public function getFehlerortReturnsInitialValueForString()
    {
        self::assertSame(
            '',
            $this->subject->getFehlerort()
        );
    }

    /**
     * @test
     */
    public function setFehlerortForStringSetsFehlerort()
    {
        $this->subject->setFehlerort('Conceived at T3CON10');

        self::assertAttributeEquals(
            'Conceived at T3CON10',
            'fehlerort',
            $this->subject
        );
    }

    /**
     * @test
     */
    public function getFehlermeldungSelectReturnsInitialValueForBool()
    {
        self::assertSame(
            false,
            $this->subject->getFehlermeldungSelect()
        );
    }

    /**
     * @test
     */
    public function setFehlermeldungSelectForBoolSetsFehlermeldungSelect()
    {
        $this->subject->setFehlermeldungSelect(true);

        self::assertAttributeEquals(
            true,
            'fehlermeldungSelect',
            $this->subject
        );
    }

    /**
     * @test
     */
    public function getFehlermeldungCodeReturnsInitialValueForString()
    {
        self::assertSame(
            '',
            $this->subject->getFehlermeldungCode()
        );
    }

    /**
     * @test
     */
    public function setFehlermeldungCodeForStringSetsFehlermeldungCode()
    {
        $this->subject->setFehlermeldungCode('Conceived at T3CON10');

        self::assertAttributeEquals(
            'Conceived at T3CON10',
            'fehlermeldungCode',
            $this->subject
        );
    }

    /**
     * @test
     */
    public function getFehlermeldungZeitpunktReturnsInitialValueForDateTime()
    {
        self::assertEquals(
            null,
            $this->subject->getFehlermeldungZeitpunkt()
        );
    }

    /**
     * @test
     */
    public function setFehlermeldungZeitpunktForDateTimeSetsFehlermeldungZeitpunkt()
    {
        $dateTimeFixture = new \DateTime();
        $this->subject->setFehlermeldungZeitpunkt($dateTimeFixture);

        self::assertAttributeEquals(
            $dateTimeFixture,
            'fehlermeldungZeitpunkt',
            $this->subject
        );
    }

    /**
     * @test
     */
    public function getDefektekomponenteSelectReturnsInitialValueForBool()
    {
        self::assertSame(
            false,
            $this->subject->getDefektekomponenteSelect()
        );
    }

    /**
     * @test
     */
    public function setDefektekomponenteSelectForBoolSetsDefektekomponenteSelect()
    {
        $this->subject->setDefektekomponenteSelect(true);

        self::assertAttributeEquals(
            true,
            'defektekomponenteSelect',
            $this->subject
        );
    }

    /**
     * @test
     */
    public function getDefektekomponenteReturnsInitialValueForString()
    {
        self::assertSame(
            '',
            $this->subject->getDefektekomponente()
        );
    }

    /**
     * @test
     */
    public function setDefektekomponenteForStringSetsDefektekomponente()
    {
        $this->subject->setDefektekomponente('Conceived at T3CON10');

        self::assertAttributeEquals(
            'Conceived at T3CON10',
            'defektekomponente',
            $this->subject
        );
    }

    /**
     * @test
     */
    public function getProgrammSelectReturnsInitialValueForBool()
    {
        self::assertSame(
            false,
            $this->subject->getProgrammSelect()
        );
    }

    /**
     * @test
     */
    public function setProgrammSelectForBoolSetsProgrammSelect()
    {
        $this->subject->setProgrammSelect(true);

        self::assertAttributeEquals(
            true,
            'programmSelect',
            $this->subject
        );
    }

    /**
     * @test
     */
    public function getProgrammZentrifugeRpmReturnsInitialValueForString()
    {
        self::assertSame(
            '',
            $this->subject->getProgrammZentrifugeRpm()
        );
    }

    /**
     * @test
     */
    public function setProgrammZentrifugeRpmForStringSetsProgrammZentrifugeRpm()
    {
        $this->subject->setProgrammZentrifugeRpm('Conceived at T3CON10');

        self::assertAttributeEquals(
            'Conceived at T3CON10',
            'programmZentrifugeRpm',
            $this->subject
        );
    }

    /**
     * @test
     */
    public function getProgrammZentrifugeRcfReturnsInitialValueForString()
    {
        self::assertSame(
            '',
            $this->subject->getProgrammZentrifugeRcf()
        );
    }

    /**
     * @test
     */
    public function setProgrammZentrifugeRcfForStringSetsProgrammZentrifugeRcf()
    {
        $this->subject->setProgrammZentrifugeRcf('Conceived at T3CON10');

        self::assertAttributeEquals(
            'Conceived at T3CON10',
            'programmZentrifugeRcf',
            $this->subject
        );
    }

    /**
     * @test
     */
    public function getProgrammZentrifugeLaufzeitReturnsInitialValueForString()
    {
        self::assertSame(
            '',
            $this->subject->getProgrammZentrifugeLaufzeit()
        );
    }

    /**
     * @test
     */
    public function setProgrammZentrifugeLaufzeitForStringSetsProgrammZentrifugeLaufzeit()
    {
        $this->subject->setProgrammZentrifugeLaufzeit('Conceived at T3CON10');

        self::assertAttributeEquals(
            'Conceived at T3CON10',
            'programmZentrifugeLaufzeit',
            $this->subject
        );
    }

    /**
     * @test
     */
    public function getProgrammZentrifugeTempReturnsInitialValueForString()
    {
        self::assertSame(
            '',
            $this->subject->getProgrammZentrifugeTemp()
        );
    }

    /**
     * @test
     */
    public function setProgrammZentrifugeTempForStringSetsProgrammZentrifugeTemp()
    {
        $this->subject->setProgrammZentrifugeTemp('Conceived at T3CON10');

        self::assertAttributeEquals(
            'Conceived at T3CON10',
            'programmZentrifugeTemp',
            $this->subject
        );
    }

    /**
     * @test
     */
    public function getProgrammZentrifugeAnlaufReturnsInitialValueForString()
    {
        self::assertSame(
            '',
            $this->subject->getProgrammZentrifugeAnlauf()
        );
    }

    /**
     * @test
     */
    public function setProgrammZentrifugeAnlaufForStringSetsProgrammZentrifugeAnlauf()
    {
        $this->subject->setProgrammZentrifugeAnlauf('Conceived at T3CON10');

        self::assertAttributeEquals(
            'Conceived at T3CON10',
            'programmZentrifugeAnlauf',
            $this->subject
        );
    }

    /**
     * @test
     */
    public function getProgrammZentrifugeAuslaufReturnsInitialValueForString()
    {
        self::assertSame(
            '',
            $this->subject->getProgrammZentrifugeAuslauf()
        );
    }

    /**
     * @test
     */
    public function setProgrammZentrifugeAuslaufForStringSetsProgrammZentrifugeAuslauf()
    {
        $this->subject->setProgrammZentrifugeAuslauf('Conceived at T3CON10');

        self::assertAttributeEquals(
            'Conceived at T3CON10',
            'programmZentrifugeAuslauf',
            $this->subject
        );
    }

    /**
     * @test
     */
    public function getProgrammInkubatorBruttemperaturReturnsInitialValueForString()
    {
        self::assertSame(
            '',
            $this->subject->getProgrammInkubatorBruttemperatur()
        );
    }

    /**
     * @test
     */
    public function setProgrammInkubatorBruttemperaturForStringSetsProgrammInkubatorBruttemperatur()
    {
        $this->subject->setProgrammInkubatorBruttemperatur('Conceived at T3CON10');

        self::assertAttributeEquals(
            'Conceived at T3CON10',
            'programmInkubatorBruttemperatur',
            $this->subject
        );
    }

    /**
     * @test
     */
    public function getProgrammInkubatorStartendpunktReturnsInitialValueForString()
    {
        self::assertSame(
            '',
            $this->subject->getProgrammInkubatorStartendpunkt()
        );
    }

    /**
     * @test
     */
    public function setProgrammInkubatorStartendpunktForStringSetsProgrammInkubatorStartendpunkt()
    {
        $this->subject->setProgrammInkubatorStartendpunkt('Conceived at T3CON10');

        self::assertAttributeEquals(
            'Conceived at T3CON10',
            'programmInkubatorStartendpunkt',
            $this->subject
        );
    }

    /**
     * @test
     */
    public function getProgrammInkubatorBrutzeitReturnsInitialValueForString()
    {
        self::assertSame(
            '',
            $this->subject->getProgrammInkubatorBrutzeit()
        );
    }

    /**
     * @test
     */
    public function setProgrammInkubatorBrutzeitForStringSetsProgrammInkubatorBrutzeit()
    {
        $this->subject->setProgrammInkubatorBrutzeit('Conceived at T3CON10');

        self::assertAttributeEquals(
            'Conceived at T3CON10',
            'programmInkubatorBrutzeit',
            $this->subject
        );
    }

    /**
     * @test
     */
    public function getProgrammInkubatorAbsenktemperaturReturnsInitialValueForString()
    {
        self::assertSame(
            '',
            $this->subject->getProgrammInkubatorAbsenktemperatur()
        );
    }

    /**
     * @test
     */
    public function setProgrammInkubatorAbsenktemperaturForStringSetsProgrammInkubatorAbsenktemperatur()
    {
        $this->subject->setProgrammInkubatorAbsenktemperatur('Conceived at T3CON10');

        self::assertAttributeEquals(
            'Conceived at T3CON10',
            'programmInkubatorAbsenktemperatur',
            $this->subject
        );
    }

    /**
     * @test
     */
    public function getProgrammInkubatorExternerkontaktReturnsInitialValueForString()
    {
        self::assertSame(
            '',
            $this->subject->getProgrammInkubatorExternerkontakt()
        );
    }

    /**
     * @test
     */
    public function setProgrammInkubatorExternerkontaktForStringSetsProgrammInkubatorExternerkontakt()
    {
        $this->subject->setProgrammInkubatorExternerkontakt('Conceived at T3CON10');

        self::assertAttributeEquals(
            'Conceived at T3CON10',
            'programmInkubatorExternerkontakt',
            $this->subject
        );
    }

    /**
     * @test
     */
    public function getProgrammInkubatorSegmentnummerReturnsInitialValueForString()
    {
        self::assertSame(
            '',
            $this->subject->getProgrammInkubatorSegmentnummer()
        );
    }

    /**
     * @test
     */
    public function setProgrammInkubatorSegmentnummerForStringSetsProgrammInkubatorSegmentnummer()
    {
        $this->subject->setProgrammInkubatorSegmentnummer('Conceived at T3CON10');

        self::assertAttributeEquals(
            'Conceived at T3CON10',
            'programmInkubatorSegmentnummer',
            $this->subject
        );
    }

    /**
     * @test
     */
    public function getFehlerBeschreibungReturnsInitialValueForString()
    {
        self::assertSame(
            '',
            $this->subject->getFehlerBeschreibung()
        );
    }

    /**
     * @test
     */
    public function setFehlerBeschreibungForStringSetsFehlerBeschreibung()
    {
        $this->subject->setFehlerBeschreibung('Conceived at T3CON10');

        self::assertAttributeEquals(
            'Conceived at T3CON10',
            'fehlerBeschreibung',
            $this->subject
        );
    }

    /**
     * @test
     */
    public function getPersonenschadenSelectReturnsInitialValueForBool()
    {
        self::assertSame(
            false,
            $this->subject->getPersonenschadenSelect()
        );
    }

    /**
     * @test
     */
    public function setPersonenschadenSelectForBoolSetsPersonenschadenSelect()
    {
        $this->subject->setPersonenschadenSelect(true);

        self::assertAttributeEquals(
            true,
            'personenschadenSelect',
            $this->subject
        );
    }

    /**
     * @test
     */
    public function getPersonenschadenReturnsInitialValueForString()
    {
        self::assertSame(
            '',
            $this->subject->getPersonenschaden()
        );
    }

    /**
     * @test
     */
    public function setPersonenschadenForStringSetsPersonenschaden()
    {
        $this->subject->setPersonenschaden('Conceived at T3CON10');

        self::assertAttributeEquals(
            'Conceived at T3CON10',
            'personenschaden',
            $this->subject
        );
    }

    /**
     * @test
     */
    public function getPersonenschadenBeschreibungReturnsInitialValueForString()
    {
        self::assertSame(
            '',
            $this->subject->getPersonenschadenBeschreibung()
        );
    }

    /**
     * @test
     */
    public function setPersonenschadenBeschreibungForStringSetsPersonenschadenBeschreibung()
    {
        $this->subject->setPersonenschadenBeschreibung('Conceived at T3CON10');

        self::assertAttributeEquals(
            'Conceived at T3CON10',
            'personenschadenBeschreibung',
            $this->subject
        );
    }

    /**
     * @test
     */
    public function getCrashSelectReturnsInitialValueForBool()
    {
        self::assertSame(
            false,
            $this->subject->getCrashSelect()
        );
    }

    /**
     * @test
     */
    public function setCrashSelectForBoolSetsCrashSelect()
    {
        $this->subject->setCrashSelect(true);

        self::assertAttributeEquals(
            true,
            'crashSelect',
            $this->subject
        );
    }

    /**
     * @test
     */
    public function getCrashReturnsInitialValueForString()
    {
        self::assertSame(
            '',
            $this->subject->getCrash()
        );
    }

    /**
     * @test
     */
    public function setCrashForStringSetsCrash()
    {
        $this->subject->setCrash('Conceived at T3CON10');

        self::assertAttributeEquals(
            'Conceived at T3CON10',
            'crash',
            $this->subject
        );
    }

    /**
     * @test
     */
    public function getCrashBeschreibungReturnsInitialValueForString()
    {
        self::assertSame(
            '',
            $this->subject->getCrashBeschreibung()
        );
    }

    /**
     * @test
     */
    public function setCrashBeschreibungForStringSetsCrashBeschreibung()
    {
        $this->subject->setCrashBeschreibung('Conceived at T3CON10');

        self::assertAttributeEquals(
            'Conceived at T3CON10',
            'crashBeschreibung',
            $this->subject
        );
    }

    /**
     * @test
     */
    public function getKurzschlussSelectReturnsInitialValueForBool()
    {
        self::assertSame(
            false,
            $this->subject->getKurzschlussSelect()
        );
    }

    /**
     * @test
     */
    public function setKurzschlussSelectForBoolSetsKurzschlussSelect()
    {
        $this->subject->setKurzschlussSelect(true);

        self::assertAttributeEquals(
            true,
            'kurzschlussSelect',
            $this->subject
        );
    }

    /**
     * @test
     */
    public function getKurzschlussReturnsInitialValueForString()
    {
        self::assertSame(
            '',
            $this->subject->getKurzschluss()
        );
    }

    /**
     * @test
     */
    public function setKurzschlussForStringSetsKurzschluss()
    {
        $this->subject->setKurzschluss('Conceived at T3CON10');

        self::assertAttributeEquals(
            'Conceived at T3CON10',
            'kurzschluss',
            $this->subject
        );
    }

    /**
     * @test
     */
    public function getKurzschlussBeschreibungReturnsInitialValueForString()
    {
        self::assertSame(
            '',
            $this->subject->getKurzschlussBeschreibung()
        );
    }

    /**
     * @test
     */
    public function setKurzschlussBeschreibungForStringSetsKurzschlussBeschreibung()
    {
        $this->subject->setKurzschlussBeschreibung('Conceived at T3CON10');

        self::assertAttributeEquals(
            'Conceived at T3CON10',
            'kurzschlussBeschreibung',
            $this->subject
        );
    }

    /**
     * @test
     */
    public function getReklamationLogistikReturnsInitialValueForBool()
    {
        self::assertSame(
            false,
            $this->subject->getReklamationLogistik()
        );
    }

    /**
     * @test
     */
    public function setReklamationLogistikForBoolSetsReklamationLogistik()
    {
        $this->subject->setReklamationLogistik(true);

        self::assertAttributeEquals(
            true,
            'reklamationLogistik',
            $this->subject
        );
    }

    /**
     * @test
     */
    public function getLogistikReturnsInitialValueForString()
    {
        self::assertSame(
            '',
            $this->subject->getLogistik()
        );
    }

    /**
     * @test
     */
    public function setLogistikForStringSetsLogistik()
    {
        $this->subject->setLogistik('Conceived at T3CON10');

        self::assertAttributeEquals(
            'Conceived at T3CON10',
            'logistik',
            $this->subject
        );
    }

    /**
     * @test
     */
    public function getLogistikBeschreibungReturnsInitialValueForString()
    {
        self::assertSame(
            '',
            $this->subject->getLogistikBeschreibung()
        );
    }

    /**
     * @test
     */
    public function setLogistikBeschreibungForStringSetsLogistikBeschreibung()
    {
        $this->subject->setLogistikBeschreibung('Conceived at T3CON10');

        self::assertAttributeEquals(
            'Conceived at T3CON10',
            'logistikBeschreibung',
            $this->subject
        );
    }

    /**
     * @test
     */
    public function getReklamationKundenserviceReturnsInitialValueForBool()
    {
        self::assertSame(
            false,
            $this->subject->getReklamationKundenservice()
        );
    }

    /**
     * @test
     */
    public function setReklamationKundenserviceForBoolSetsReklamationKundenservice()
    {
        $this->subject->setReklamationKundenservice(true);

        self::assertAttributeEquals(
            true,
            'reklamationKundenservice',
            $this->subject
        );
    }

    /**
     * @test
     */
    public function getKundenserviceReturnsInitialValueForString()
    {
        self::assertSame(
            '',
            $this->subject->getKundenservice()
        );
    }

    /**
     * @test
     */
    public function setKundenserviceForStringSetsKundenservice()
    {
        $this->subject->setKundenservice('Conceived at T3CON10');

        self::assertAttributeEquals(
            'Conceived at T3CON10',
            'kundenservice',
            $this->subject
        );
    }

    /**
     * @test
     */
    public function getKundenserviceBeschreibungReturnsInitialValueForString()
    {
        self::assertSame(
            '',
            $this->subject->getKundenserviceBeschreibung()
        );
    }

    /**
     * @test
     */
    public function setKundenserviceBeschreibungForStringSetsKundenserviceBeschreibung()
    {
        $this->subject->setKundenserviceBeschreibung('Conceived at T3CON10');

        self::assertAttributeEquals(
            'Conceived at T3CON10',
            'kundenserviceBeschreibung',
            $this->subject
        );
    }

    /**
     * @test
     */
    public function getMassnahmenReturnsInitialValueForString()
    {
        self::assertSame(
            '',
            $this->subject->getMassnahmen()
        );
    }

    /**
     * @test
     */
    public function setMassnahmenForStringSetsMassnahmen()
    {
        $this->subject->setMassnahmen('Conceived at T3CON10');

        self::assertAttributeEquals(
            'Conceived at T3CON10',
            'massnahmen',
            $this->subject
        );
    }

    /**
     * @test
     */
    public function getUploadReturnsInitialValueForFileReference()
    {
        self::assertEquals(
            null,
            $this->subject->getUpload()
        );
    }

    /**
     * @test
     */
    public function setUploadForFileReferenceSetsUpload()
    {
        $fileReferenceFixture = new \TYPO3\CMS\Extbase\Domain\Model\FileReference();
        $this->subject->setUpload($fileReferenceFixture);

        self::assertAttributeEquals(
            $fileReferenceFixture,
            'upload',
            $this->subject
        );
    }
}
